<?php require('./src/component/navbar.php'); ?>
<section class="breadcrumb-wrapper fix bg-cover py-5">
    <div class="container">
        <div class="row justify-content-center align-items-center text-center">
            <div class="col">
                <div class="page-heading">
                    <h2 class="wow fadeInUp" data-wow-delay=".3s"
                        style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">Todos los Cursos
                    </h2>
                    <ul class="breadcrumb-list wow fadeInUp list-inline" data-wow-delay=".5s"
                        style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                        <li class="list-inline-item">
                            <a href="index.php">Home</a>
                        </li>
                        <li class="list-inline-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="list-inline-item">Todos los Cursos</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>




<section class="courses-section section-padding fix">
    <div class="container">
        <div class="courses-wrapper mt-0">
            <div class="row justify-content-center">
                <div class="col-xl-9">
                    <ul class="nav" role="tablist">
                        <!-- Pestaña de todas las categorías -->
                        <li class="nav-item style-2 wow fadeInUp" data-wow-delay=".2s" role="presentation">
                            <a href="#all" data-bs-toggle="tab" class="nav-link active" aria-selected="true" role="tab">
                                All Categories
                            </a>
                        </li>

                        <?php
                        $consulta = mysqli_query($conexion, "SELECT categoria_id, titulo FROM categoria ORDER BY updated_at DESC LIMIT 5");
                        while ($row = mysqli_fetch_assoc($consulta)) {
                        ?>
                            <li class="nav-item wow fadeInUp" data-wow-delay=".4s" role="presentation">
                                <a href="#cat<?= $row["categoria_id"] ?>" data-bs-toggle="tab" class="nav-link"
                                    aria-selected="false" role="tab">
                                    <?= $row["titulo"] ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>

            <!-- Contenido de las pestañas -->
            <div class="tab-content mt-4">
                <!-- Panel: All Categories -->
                <div id="all" class="tab-pane fade active show" role="tabpanel">
                    <div class="row">
                        <?php
                        $allCourses = mysqli_query($conexion, "
                            SELECT c.curso_id, c.curso_title, cat.titulo 
                            FROM cursos c 
                            LEFT JOIN categoria cat ON c.categoria_id = cat.categoria_id
                        ");
                        while ($row = mysqli_fetch_assoc($allCourses)) {
                        ?>
                            <div class="col-xl-4 col-lg-6 col-md-6">
                                <div class="featured-courses-item-2">
                                    <div class="courses-image">
                                        <img src="https://cdn.euroinnova.edu.es/img/subidasEditor/autom-1607615062.webp"
                                            alt="img">
                                        <h6 class="time"><?= $row["titulo"] ?></h6>
                                    </div>
                                    <div class="courses-content">
                                        <div class="courses-part">
                                            <a href="courses-details.html" class="small-btn">Free</a>
                                        </div>
                                        <h4><a
                                                href="detalles-curso.php?cursodetalle=<?= $row["curso_id"] ?>"><?= $row["curso_title"] ?></a>
                                        </h4>
                                        <ul class="courses-meta">
                                            <li>
                                                <i class="fa-solid fa-users"></i>
                                                169 Students
                                            </li>
                                            <li>
                                                <i class="fa-solid fa-book-open-reader"></i>
                                                12 Lessons
                                            </li>
                                        </ul>
                                        <div class="courses-info-item">
                                            <div class="courses-info">
                                                <div class="info-image">
                                                    <img src="https://i.pinimg.com/originals/61/02/2c/61022c12a08851a91352dc9c7b2dd934.jpg"
                                                        alt="img">
                                                </div>
                                                <h5>Jane Cooper</h5>
                                            </div>
                                            <div class="star">
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star"></i>
                                                <i class="fa-solid fa-star color"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <!-- Paneles por categoría -->
                <?php
                $consulta = mysqli_query($conexion, "SELECT categoria_id, titulo FROM categoria ORDER BY updated_at DESC LIMIT 5");
                while ($cat = mysqli_fetch_assoc($consulta)) {
                ?>
                    <div id="cat<?= $cat["categoria_id"] ?>" class="tab-pane fade" role="tabpanel">
                        <div class="row">
                            <?php
                            $idcat = $cat["categoria_id"];
                            $cursos = mysqli_query($conexion, "
                                SELECT c.curso_id, c.curso_title, cat.titulo 
                                FROM cursos c 
                                LEFT JOIN categoria cat ON c.categoria_id = cat.categoria_id 
                                WHERE c.categoria_id = $idcat
                            ");
                            while ($curso = mysqli_fetch_assoc($cursos)) {
                            ?>
                                <div class="col-xl-4 col-lg-6 col-md-6">
                                    <div class="featured-courses-item-2">
                                        <div class="courses-image">
                                            <img src="https://cdn.euroinnova.edu.es/img/subidasEditor/autom-1607615062.webp"
                                                alt="img">
                                            <h6 class="time"><?= $curso["titulo"] ?></h6>
                                        </div>
                                        <div class="courses-content">
                                            <div class="courses-part">
                                                <a href="courses-details.html" class="small-btn">Free</a>
                                            </div>
                                            <h4><a
                                                    href="detalles-curso.php?cursodetalle=<?= $curso["curso_id"] ?>"><?= $curso["curso_title"] ?></a>
                                            </h4>
                                            <ul class="courses-meta">
                                                <li>
                                                    <i class="fa-solid fa-users"></i>
                                                    169 Students
                                                </li>
                                                <li>
                                                    <i class="fa-solid fa-book-open-reader"></i>
                                                    12 Lessons
                                                </li>
                                            </ul>
                                            <div class="courses-info-item">
                                                <div class="courses-info">
                                                    <div class="info-image">
                                                        <img src="https://i.pinimg.com/originals/61/02/2c/61022c12a08851a91352dc9c7b2dd934.jpg"
                                                            alt="img">
                                                    </div>
                                                    <h5>Jane Cooper</h5>
                                                </div>
                                                <div class="star">
                                                    <i class="fa-solid fa-star"></i>
                                                    <i class="fa-solid fa-star"></i>
                                                    <i class="fa-solid fa-star"></i>
                                                    <i class="fa-solid fa-star"></i>
                                                    <i class="fa-solid fa-star color"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>


<?php require('./src/component/footer.php'); ?>