<?php require('./src/component/navbar.php'); ?>
<section class="hero-section container d-flex flex-wrap align-items-center justify-content-center">
    <div class="hero-text col-md-6">
        <span class="sub-title mb-3">Bienvenido a tu plataforma de capacitaión</span>
        <h1>
            Desarrolla tu <br />
            potencial, <br />
            paso a paso
        </h1>
        <p class="my-4">
            Impulsa a tus profesionales en cualquier puesto, perfil o sector,
            capacitándolos para alcanzar el éxito en las áreas estratégicas de tu
            empresa.
        </p>
        <a href="#" class="btn theme-btn me-3 p-3 rounded-pill">Explorar Cursos <i class="fas fa-arrow-right"></i></a>
        <a href="#" class="btn btn-outline-secondary rounded-circle open-video" data-bs-toggle="modal"
            data-bs-target="#videoModal" data-title="Curso de Liderazgo"
            data-video="https://www.youtube.com/embed/TOx0o5ulrCI?si=5u0cjWoxFXf-8szR"><i class="fas fa-play"></i></a>
    </div>
    <div class="img-stack col-md-3 text-center mt-4 mt-md-0">
        <img src="./src/assets/img/hero-1.png" class="hero-image img-fluid" alt="Learning Illustration" />
    </div>
    <div class="img-stack-dos col-md-3 text-center mt-4 mt-md-0">
        <img src="./src/assets/img/hero-2.png" class="hero-image img-fluid" alt="Learning Illustration" />
    </div>
    <div class="circle-bg"></div>
</section>

<div class="modal fade" id="videoModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="videoModalTitle"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <div id="videoContainer" class="ratio ratio-16x9"></div>
            </div>
        </div>
    </div>
</div>

<section class="section-nosotros container">
    <div class="row">
        <div class="col-lg-6 col-md-6 col-12 div-border-img row justify-content-center align-items-center">
            <div class="border-img border border-primary border-5">
                <img src="./src/assets/img/section_about.jpg" width="100%" height="100%" alt="" />
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-12">
            <div class="feature-content">
                <div class="title">
                    <span class="wow fadeInRight" data-wow-delay=".3s">Sobre Nosotros</span>
                    <h3 class="wow fadeInRight" data-wow-delay=".5s">
                        Impulsa Tus Habilidades <br />
                        Con Nuevos Conocimientos
                    </h3>
                </div>
                <div class="feature-item wow fadeInUp" data-wow-delay=".5s">
                    <div class="feature-thumb">💡</div>
                    <div class="banner-content">
                        <h2 class="title">Versatilidad Profesional</h2>
                        <p>
                            Nuestros cursos se adaptan a cualquier perfil, desde
                            operativos hasta ejecutivos, garantizando aprendizaje
                            relevante sin importar el sector o nivel de experiencia.
                        </p>
                    </div>
                </div>
                <div class="feature-item wow fadeInUp" data-wow-delay=".6s">
                    <div class="feature-thumb">⚙️</div>
                    <div class="banner-content">
                        <h2 class="title">Enfoque Estratégico</h2>
                        <p>
                            Cada contenido está diseñado para fortalecer las competencias
                            clave que impulsan el crecimiento de las empresas, alineándose
                            con los objetivos del negocio.
                        </p>
                    </div>
                </div>
                <div class="feature-item wow fadeInUp" data-wow-delay=".7s">
                    <div class="feature-thumb">🚀</div>
                    <div class="banner-content">
                        <h2 class="title">Impulso al Éxito</h2>
                        <p>
                            Capacitamos a tus colaboradores para que no solo cumplan con
                            su rol, sino que se conviertan en líderes dentro de su área,
                            preparados para asumir nuevos retos.
                        </p>
                    </div>
                </div>
                <div class="feature-item wow fadeInUp" data-wow-delay=".7s">
                    <div class="">
                        <button class="btn btn-purple me-3 p-3 rounded-pill">
                            Nosotros <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section-categorias">
    <div class="container">
        <div class="section-title-area">
            <div class="section-title">
                <span class="sub-title wow fadeInUp">Nuestras Categorias</span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s" style="
                visibility: visible;
                animation-delay: 0.3s;
                animation-name: fadeInUp;
              ">
                    Categorias de los Cursos
                </h2>
            </div>
            <a href="categoria-cursos.php" class="theme-btn wow fadeInUp" data-wow-delay=".5s" style="
              visibility: visible;
              animation-delay: 0.5s;
              animation-name: fadeInUp;
            ">Explorar todos los cursos <i class="fa-solid fa-arrow-right"></i></a>
        </div>
        <div class="row">
            <?php

            $consulta = mysqli_query($conexion, "SELECT
    cat.categoria_id,
    cat.titulo,
    cat.updated_at,
    COUNT(curs.curso_id) AS total_cursos
FROM
    categoria cat
LEFT JOIN
    cursos curs ON cat.categoria_id = curs.categoria_id
GROUP BY
    cat.categoria_id, cat.titulo, cat.updated_at LIMIT 4;
");
            while ($row = mysqli_fetch_assoc($consulta)) {
            ?>
                <div class="col-xl-3 col-lg-4 col-md-6 col-md-6 wow fadeInUp" data-wow-delay=".2s" style="
              visibility: visible;
              animation-delay: 0.2s;
              animation-name: fadeInUp;
            ">
                    <div class="all-courses-item">
                        <div class="courses-image">
                            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT8WNBuaawjENna-p3vaowOdEZvppaI0yFRwg&s"
                                alt="img" />
                        </div>
                        <div class="courses-content">
                            <div class="content">
                                <h3>
                                    <a
                                        href="categoria-cursos.php?id_categoria=<?php echo $row["categoria_id"] ?>"><?= $row["titulo"] ?></a>
                                </h3>
                                <p>Cursos: <?= $row["total_cursos"] ?></p>
                            </div>
                            <div class="icon">
                                <a href="categoria-cursos.php?id_categoria=<?php echo $row["categoria_id"] ?>"><i
                                        class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</section>

<section class="featured-courses-section section-padding fix">
    <div class="container">
        <div class="section-title text-center">
            <span class="sub-title wow fadeInUp" style="visibility: visible; animation-name: fadeInUp">Explora
                Cursos</span>
            <h2 class="wow fadeInUp" data-wow-delay=".3s" style="
              visibility: visible;
              animation-delay: 0.3s;
              animation-name: fadeInUp;
            ">
                Catálogo siempre actualizado
            </h2>
        </div>
        <div class="row">
            <?php
            $allCourses = mysqli_query($conexion, "
    SELECT c.curso_id, c.curso_title, cat.titulo, c.updated_at 
    FROM cursos c 
    LEFT JOIN categoria cat ON c.categoria_id = cat.categoria_id
");

            while ($row = mysqli_fetch_assoc($allCourses)) {
                $curso_id = (int)$row['curso_id'];
                $curso_title = $row['curso_title'];
                $categoria = $row['titulo'];
                $updated_at = date("M d, Y", strtotime($row['updated_at']));

                // Verificamos si es par o impar
                $isEven = $curso_id % 2 === 0;

                // Dirección de animación y posición de la tarjeta
                $animation = $isEven ? 'fadeInLeft' : 'fadeInRight';
                $colClass = $isEven ? 'col-lg-6 mb-4' : 'col-lg-6 mb-4 ms-auto';

                echo '
    <div class="' . $colClass . '">
        <div class="featured-courses-item wow ' . $animation . '" data-wow-delay=".3s">
            <div class="featured-image">
                <img src="https://archivos.juridicas.unam.mx/diplomados/imagenes/tSIbXxavflEeIZY51jS0qeWnJtpEOLaR75XqaNdT.jpeg" alt="img" />
                <h6 class="time">
                    <i class="fa-regular fa-calendar-days"></i> ' . $updated_at . '
                </h6>
            </div>
            <div class="featured-courses-content">
                <ul class="courses-meta">
                    <li><i class="fa-solid fa-users"></i> 169 Students</li>
                    <li><i class="fa-solid fa-book-open-reader"></i> 12 Lessons</li>
                </ul>
                <h4>
                    <a href="detalles-curso.php?cursodetalle=' . $curso_id . '"> ' . htmlspecialchars($curso_title) . ' </a>
                </h4>
                <div class="star">
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star"></i>
                    <i class="fa-solid fa-star color"></i>
                    <span>(09 Reviews)</span>
                </div>
                <div class="featured-part">
                    <span>$674.00</span>
                    <ul class="graduate">
                        <li><i class="fa-regular fa-clock"></i> 3 hr 40 min</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>';
            }
            ?>
        </div>


    </div>
</section>

<section class="contact-section section-padding fix bg-cover" style="
        background-image: linear-gradient(
            rgba(0, 0, 0, 0.8),
            rgba(0, 0, 0, 0.8)
          ),
          url('https://www.cenforpro.com/wp-content/uploads/2022/02/PAGINA-CENFORPRO.png');
        background-size: cover;
        background-position: center;
      ">
    <div class="container">
        <div class="contact-wrapper">
            <div class="row g-4 justify-content-between">
                <div class="col-lg-6">
                    <div class="contact-content">
                        <div class="section-title">
                            <span class="sub-title text-white style-2 wow fadeInUp"
                                style="visibility: visible; animation-name: fadeInUp">Contáctanos para más
                                información</span>
                            <h2 class="text-white wow fadeInUp" data-wow-delay=".3s" style="
                      visibility: visible;
                      animation-delay: 0.3s;
                      animation-name: fadeInUp;
                    ">
                                Transforma la Forma de Aprender: Inspira el Cambio desde la
                                Acción
                            </h2>
                            <p class="text-white mt-3 mt-mb-0 wow fadeInUp" data-wow-delay=".5s" style="
                      visibility: visible;
                      animation-delay: 0.5s;
                      animation-name: fadeInUp;
                    ">
                                Ayuda a tu equipo a aprender haciendo,<br />
                                con ejemplos prácticos que los motivan a cambiar sus hábitos
                                y aplicar lo aprendido desde el primer día.
                            </p>
                        </div>
                        <div class="contact-item wow fadeInUp" data-wow-delay=".3s" style="
                    visibility: visible;
                    animation-delay: 0.3s;
                    animation-name: fadeInUp;
                  ">
                            <div class="icon">
                                <i class="fa fa-paper-plane" style="font-size: 30px" aria-hidden="true"></i>
                            </div>
                            <div class="content">
                                <h3>Aprende Haciendo, Aplica Sin Dudar.</h3>
                                <p>
                                    Entrenamiento basado en casos reales y escenarios
                                    cotidianos, diseñado para fomentar conductas sostenibles
                                    que optimicen el rendimiento profesional.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="contact-box">
                        <h3 class="wow fadeInUp" data-wow-delay=".5s" style="
                    visibility: visible;
                    animation-delay: 0.5s;
                    animation-name: fadeInUp;
                  ">
                            Contactanos
                        </h3>
                        <form action="contact.php" id="contact-form" method="POST" class="contact-form-items">
                            <div class="row g-4">
                                <div class="col-lg-12 wow fadeInUp" data-wow-delay=".3s" style="
                        visibility: visible;
                        animation-delay: 0.3s;
                        animation-name: fadeInUp;
                      ">
                                    <div class="form-clt">
                                        <input type="text" name="name" id="email4" placeholder="Nombre" />
                                    </div>
                                </div>
                                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".5s" style="
                        visibility: visible;
                        animation-delay: 0.5s;
                        animation-name: fadeInUp;
                      ">
                                    <div class="form-clt">
                                        <input type="text" name="email" id="name4" placeholder="Email" />
                                    </div>
                                </div>
                                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s" style="
                        visibility: visible;
                        animation-delay: 0.3s;
                        animation-name: fadeInUp;
                      ">
                                    <div class="form-clt">
                                        <input type="text" name="name" id="name5" placeholder="Telefono" />
                                    </div>
                                </div>
                                <div class="col-lg-12 wow fadeInUp" data-wow-delay=".5s" style="
                        visibility: visible;
                        animation-delay: 0.5s;
                        animation-name: fadeInUp;
                      ">
                                    <div class="form-clt">
                                        <input type="text" name="name" id="name6" placeholder="Domicilio" />
                                    </div>
                                </div>
                                <div class="col-lg-12 wow fadeInUp" data-wow-delay=".3s" style="
                        visibility: visible;
                        animation-delay: 0.3s;
                        animation-name: fadeInUp;
                      ">
                                    <div class="form-clt">
                                        <textarea name="message" id="message"
                                            placeholder="Agrega Comentario"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12 wow fadeInUp" data-wow-delay=".5s" style="
                        visibility: visible;
                        animation-delay: 0.5s;
                        animation-name: fadeInUp;
                      ">
                                    <button type="submit" class="theme-btn">
                                        Enviar <i class="fa-solid fa-arrow-right"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require('./src/component/footer.php'); ?>