<?php
session_start();

$cursoiniciado = isset($_GET['cursoenproceso']) ? (int) $_GET['cursoenproceso'] : null;

if (!isset($_SESSION["usuario_id"])) {
    header("Location: ../../../../login/login.php");
    exit();
}

// SOLO si se recibe el parámetro y aún NO está marcada la sesión
if ($cursoiniciado !== null && !isset($_SESSION['curso_en_progreso'])) {
    $_SESSION['curso_en_progreso'] = true;
}

// VALIDAR: si no hay curso en progreso, redirigir al panel
if (!isset($_SESSION['curso_en_progreso']) || $_SESSION['curso_en_progreso'] !== true) {
    header("Location: ../panel-curso/panel-curso.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Bloque 1 - Fundamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
    .progress {
        height: 25px;
    }

    .tema-completado {
        text-decoration: line-through;
        color: green;
    }

    .video-container {
        position: relative;
        padding-bottom: 56.25%;
        height: 0;
        overflow: hidden;
    }

    .video-container iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    .fade.show {
        opacity: 1 !important;
    }
    </style>
</head>


<body>
    <div class="container py-4">

    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    const cursoID = <?php echo json_encode($cursoiniciado); ?>;

    // Contenedor donde se agregarán los bloques
    const container = document.querySelector(".container");

    // Variables globales para controlar el estado
    let todosTemasCompletados = false;
    let cuestionarioMostrado = false;
    let preguntasGlobales = [];

   



    function generarBloque(tema, temaIndex) {
        const bloqueDiv = document.createElement("div");
        bloqueDiv.className = `tema-container mb-5 p-4 border rounded bg-light animate__animated animate__fadeIn`;

        bloqueDiv.style.display = temaIndex === 0 ? "block" : "none"; // Solo muestra el primer tema al inicio

        bloqueDiv.innerHTML = `
        <h2 class="mb-3 text-primary"><i class="bi bi-journal-bookmark-fill"></i> ${tema.titulo}</h2>
        <div class="mb-4">
            <div class="progress" style="height: 25px;">
                <div id="progress-bar-${temaIndex}" class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: 0%">
                    0%
                </div>
            </div>
        </div>
        <ul class="list-group list-group-flush mb-4" id="lista-temas-${temaIndex}"></ul>
        <div class="text-end">
            <button class="btn btn-success btn-lg" id="siguiente-tema-${temaIndex}">
                <i class="bi bi-arrow-right-circle-fill"></i> Siguiente Tema
            </button>
        </div>

        <div id="reproductor-container-${temaIndex}" class="mt-4 border p-3 rounded bg-white shadow-sm" style="display: none;">
            <div id="reproductor-${temaIndex}" class="mb-3"></div>
            <div id="controles-material-${temaIndex}" class="d-flex align-items-center" style="display: none;">
                <button id="siguiente-material-${temaIndex}" class="btn btn-outline-primary btn-sm">
                    <i class="bi bi-skip-forward-fill"></i> Siguiente Material
                </button>
                <span id="contador-material-${temaIndex}" class="ms-3 text-muted"></span>
            </div>
        </div>
    `;

        container.appendChild(bloqueDiv);

        const listaTemas = bloqueDiv.querySelector(`#lista-temas-${temaIndex}`);
        const progressBar = bloqueDiv.querySelector(`#progress-bar-${temaIndex}`);
        const siguienteTema = bloqueDiv.querySelector(`#siguiente-tema-${temaIndex}`);
        const reproductorContainer = bloqueDiv.querySelector(`#reproductor-container-${temaIndex}`);
        const reproductor = bloqueDiv.querySelector(`#reproductor-${temaIndex}`);
        const controlesMaterial = bloqueDiv.querySelector(`#controles-material-${temaIndex}`);
        const siguienteMaterial = bloqueDiv.querySelector(`#siguiente-material-${temaIndex}`);
        const contadorMaterial = bloqueDiv.querySelector(`#contador-material-${temaIndex}`);

        let temaActual = 0;
        let materialActual = 0;
        let materialesActuales = [];

        // Mostrar subtemas
        if (tema.contenidos && tema.contenidos.length > 0) {
            tema.contenidos.forEach((contenido, index) => {
                const li = document.createElement("li");
                li.className = "list-group-item d-flex justify-content-between align-items-center";
                li.innerHTML = `
                ${contenido.nombre}
                <span class="badge bg-secondary" id="check-${temaIndex}-${index}">
                    <i class="bi bi-hourglass-split"></i>
                </span>
            `;
                listaTemas.appendChild(li);
            });
        } else {
            listaTemas.innerHTML = '<li class="list-group-item">No hay subtemas disponibles</li>';
        }

        siguienteTema.addEventListener("click", () => {
    if (temaActual < (tema.contenidos?.length || 0)) {
        const check = document.getElementById(`check-${temaIndex}-${temaActual}`);
        if (check) {
            check.innerHTML = `<i class="bi bi-check-circle-fill"></i>`;
            check.classList.replace("bg-secondary", "bg-success");
        }

        const contenidoActual = tema.contenidos[temaActual];

        // Adaptar si los materiales vienen como campos concatenados
        if (contenidoActual?.rutas_materiales && contenidoActual?.tipos_materiales && contenidoActual?.ids_materiales) {
            const rutas = contenidoActual.rutas_materiales.split('|');
            const tipos = contenidoActual.tipos_materiales.split('|');
            const ids = contenidoActual.ids_materiales.split('|');

            contenidoActual.materiales = rutas.map((ruta, i) => ({
                tipo: tipos[i]?.toLowerCase() || '',
                ruta: ruta,
                id: parseInt(ids[i], 10) || null,
                nombre: ruta.split('/').pop() || `material-${i + 1}`
            }));
        }

        if (contenidoActual?.materiales && contenidoActual.materiales.length > 0) {
            // No usar filtro de tipo único, permitir duplicados del mismo tipo
            materialesActuales = contenidoActual.materiales
                .filter(material => ['video', 'pdf', 'word'].includes(material.tipo));

            materialActual = 0;
            if (materialesActuales.length > 0) {
                mostrarMaterial(temaIndex, materialActual);
                reproductorContainer.style.display = "block";
                controlesMaterial.style.display = materialesActuales.length > 1 ? "flex" : "none";
                actualizarContadorMaterial();
            } else {
                reproductorContainer.style.display = "none";
            }
        }

        temaActual++;
        calcularProgresoPorTemas();

        if (temaActual >= tema.contenidos.length) {
            siguienteTema.innerHTML = `<i class="bi bi-check-circle-fill"></i> Finalizar Tema`;

            siguienteTema.removeEventListener("click", arguments.callee);
            siguienteTema.addEventListener("click", () => {
                const temas = document.querySelectorAll('.tema-container');
                temas[temaIndex].classList.add("animate__animated", "animate__fadeOut");

                temas[temaIndex].addEventListener('animationend', () => {
                    temas[temaIndex].style.display = "none";

                    if (temas[temaIndex + 1]) {
                        temas[temaIndex + 1].style.display = "block";
                        temas[temaIndex + 1].classList.add("animate__animated", "animate__fadeIn");
                    } else {
                        Swal.fire({
                            title: "¡Curso terminado!",
                            text: "Has completado todos los temas. Puedes realizar la evaluación.",
                            icon: "success",
                            confirmButtonText: "Continuar",
                        });
                    }

                    verificarTodosTemasCompletados();
                }, { once: true });
            });
        }
    }
});






        function calcularProgresoPorTemas() {
            const todosTemas = document.querySelectorAll('.tema-container');
            let temasCompletos = 0;

            todosTemas.forEach((tema) => {
                const checks = tema.querySelectorAll('.list-group-item .badge.bg-success');
                const totalChecks = tema.querySelectorAll('.list-group-item .badge').length;

                if (checks.length === totalChecks && totalChecks > 0) {
                    temasCompletos++;
                }
            });

            const progresoGeneral = Math.floor((temasCompletos / todosTemas.length) * 100);

            // Actualizar progreso en cada progress bar
            todosTemas.forEach((tema, index) => {
                const pb = tema.querySelector(`#progress-bar-${index}`);
                if (pb) {
                    pb.style.width = `${progresoGeneral}%`;
                    pb.innerText = `${progresoGeneral}%`;
                }
            });

            fetch('../../../../controllers/actualizar-progreso-curso.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `curso_id=${cursoID}&progreso=${progresoGeneral}`
            }).catch(error => console.error('Error al actualizar progreso:', error));
        }

        siguienteMaterial.addEventListener("click", () => {
            materialActual++;
            if (materialActual < materialesActuales.length) {
                mostrarMaterial(temaIndex, materialActual);
                actualizarContadorMaterial();
            } else {
                reproductorContainer.style.display = "none";
            }
        });
        
        
        function mostrarMaterial(temaIndex, materialIndex) {
    const material = materialesActuales[materialIndex];
    reproductor.innerHTML = '';

    console.log("Material actual:", material);

    const tipo = material.tipo ? material.tipo.toLowerCase().trim() : '';
    const rutaMaterial = material.ruta.replace(/^(\.\.\/)+/, '').trim();
    const rutaCompleta = material.ruta.startsWith('http')
        ? material.ruta
        : `../../../../controllers/${rutaMaterial}`;

    reproductor.innerHTML = `
        <div class="d-flex flex-column justify-content-center align-items-center py-5">
            <div class="spinner-border text-primary mb-3" style="width: 3rem; height: 3rem;" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
            <h5 class="text-primary">Cargando ${tipo === 'video' ? 'video' : 'documento'}...</h5>
        </div>
    `;

    setTimeout(() => {
        if (tipo === 'video') {
            reproductor.innerHTML = `
                <div class="mb-3">
                    <h5 class="d-flex align-items-center">
                        <i class="fas fa-film me-2 text-primary"></i>
                        ${material.nombre}
                    </h5>
                    <small class="text-muted">Video formativo</small>
                </div>
                <div class="ratio ratio-16x9 bg-dark rounded-3 overflow-hidden shadow">
                    <video controls class="w-100" style="background-color: #000;">
                        <source src="${rutaCompleta}" type="video/mp4">
                        Tu navegador no soporta el elemento de video.
                    </video>
                </div>
                <div class="mt-3 text-end">
                    <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-external-link-alt me-1"></i>Abrir en nueva pestaña
                    </a>
                </div>
            `;
        } else if (tipo === 'pdf') {
            reproductor.innerHTML = `
                <div class="mb-3">
                    <h5 class="d-flex align-items-center">
                        <i class="fas fa-file-pdf me-2 text-danger"></i>
                        ${material.nombre}
                    </h5>
                    <small class="text-muted">Documento PDF</small>
                </div>
                <div class="ratio ratio-16x9 bg-light rounded-3 overflow-hidden shadow">
                    <iframe src="${rutaCompleta}#view=fitH&toolbar=0&navpanes=0" 
                            class="w-100 border-0" 
                            style="background-color: #fff;">
                    </iframe>
                </div>
                <div class="mt-3 d-flex justify-content-between">
                    <a href="${rutaCompleta}" download class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-download me-1"></i>Descargar
                    </a>
                    <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-external-link-alt me-1"></i>Abrir completo
                    </a>
                </div>
            `;
        } else if (tipo === 'word') {
            reproductor.innerHTML = `
                <div class="mb-3">
                    <h5 class="d-flex align-items-center">
                        <i class="fas fa-file-word me-2 text-primary"></i>
                        ${material.nombre}
                    </h5>
                    <small class="text-muted">Documento Word</small>
                </div>
                <div class="ratio ratio-16x9 bg-light rounded-3 overflow-hidden shadow">
                    <iframe src="https://docs.google.com/gview?url=${encodeURIComponent(rutaCompleta)}&embedded=true"
                            class="w-100 border-0"
                            style="background-color: #fff;">
                    </iframe>
                </div>
                <div class="mt-3 d-flex justify-content-between">
                    <a href="${rutaCompleta}" download class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-download me-1"></i>Descargar
                    </a>
                    <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-external-link-alt me-1"></i>Abrir completo
                    </a>
                </div>
            `;
        } else {
            reproductor.innerHTML = `<div class="alert alert-warning">Tipo de material desconocido.</div>`;
        }

        reproductor.classList.add("animate__animated", "animate__fadeIn");
    }, 800);
}


        function actualizarContadorMaterial() {
            contadorMaterial.textContent = `Material ${materialActual + 1} de ${materialesActuales.length}`;
        }
    }



   

    // Función para verificar si todos los temas están completos
    function verificarTodosTemasCompletados() {
        const todosTemas = document.querySelectorAll('.tema-container');
        let temasCompletos = 0;

        todosTemas.forEach((tema) => {
            const checks = tema.querySelectorAll('.list-group-item .badge.bg-success');
            const totalChecks = tema.querySelectorAll('.list-group-item .badge').length;

            if (checks.length === totalChecks && totalChecks > 0) {
                temasCompletos++;
            }
        });

        if (temasCompletos === todosTemas.length && !cuestionarioMostrado && preguntasGlobales.length > 0) {
            mostrarCuestionarioFinal();
            cuestionarioMostrado = true;
        }
    }

   

    // Función para mostrar el cuestionario final
    function mostrarCuestionarioFinal() {
        // Bloquear el botón de retroceso del navegador
        history.pushState(null, null, location.href);
        window.onpopstate = function(event) {
            history.go(1);
            alert("No puedes volver atrás durante el cuestionario. Debes completarlo para continuar.");
        };

        // Controlar cierre de ventana/pestaña
        window.onbeforeunload = function(e) {
            e.preventDefault();
            e.returnValue = '¿Estás seguro de que quieres salir? Perderás todo tu progreso en el cuestionario.';
            return e.returnValue;
        };

        const cuestionarioDiv = document.createElement("div");
        cuestionarioDiv.className = "mt-5 p-4 border rounded bg-light";
        cuestionarioDiv.innerHTML = `
        <h2 class="mb-4">Cuestionario Final</h2>
        <form id="form-cuestionario-final">
            <div id="preguntas-final-container"></div>
            <button type="submit" class="btn btn-success mt-3">Enviar Cuestionario</button>
        </form>
    `;
        container.appendChild(cuestionarioDiv);

        const preguntasContainer = document.getElementById("preguntas-final-container");

        preguntasGlobales.forEach((pregunta, index) => {
            const preguntaDiv = document.createElement("div");
            preguntaDiv.className = "mb-4 p-3 border rounded bg-white";

            let opcionesHTML = "";
            if (pregunta.opciones && pregunta.opciones.length > 0) {
                pregunta.opciones.forEach((opcion, opcionIndex) => {
                    opcionesHTML += `
                <div class="form-check mb-2">
                    <input class="form-check-input" type="radio" 
                           name="pregunta-final-${index}" 
                           id="pregunta-final-${index}-${opcionIndex}"
                           value="${opcion.id}" required>
                    <label class="form-check-label" for="pregunta-final-${index}-${opcionIndex}">
                        ${opcion.texto}
                    </label>
                </div>
            `;
                });
            }

            preguntaDiv.innerHTML = `
        <h5 class="mb-3">${index + 1}. ${pregunta.texto}</h5>
        ${opcionesHTML}
    `;
            preguntasContainer.appendChild(preguntaDiv);
        });

        // Manejar envío del cuestionario final
        document.getElementById("form-cuestionario-final").addEventListener("submit", (e) => {
            e.preventDefault();
            // Eliminar los controladores cuando se envía el formulario
            window.onpopstate = null;
            window.onbeforeunload = null;
            calificarCuestionarioFinal();
        });
    }


    // Función para calificar el cuestionario final y manejar certificados
    async function calificarCuestionarioFinal() {
        try {
            // Calcular respuestas correctas
            let respuestasCorrectas = 0;

            preguntasGlobales.forEach((pregunta, index) => {
                const selectedOption = document.querySelector(
                    `input[name="pregunta-final-${index}"]:checked`);

                if (selectedOption) {
                    const opcionId = selectedOption.value;
                    const opcion = pregunta.opciones.find(op => op.id == opcionId);
                    if (opcion && opcion.correcta) {
                        respuestasCorrectas++;
                    }
                }
            });

            // Calcular puntuación
            const calificacion = (respuestasCorrectas / preguntasGlobales.length) * 10;
            const calificacionRedondeada = calificacion.toFixed(1);

            // Mostrar resultado con SweetAlert
            const result = await Swal.fire({
                title: 'Resultado del Cuestionario',
                html: `Tu calificación: <strong>${calificacionRedondeada}/10</strong>`,
                icon: calificacion > 5 ? 'success' : 'info',
                showCancelButton: calificacion > 5,
                confirmButtonText: calificacion > 5 ? 'Descargar Certificado' : 'Aceptar',
                cancelButtonText: 'Volver al Curso',
                showDenyButton: calificacion < 5,
                denyButtonText: 'Reintentar Cuestionario'
            });

            // Manejar acciones según la calificación
            if (calificacion >= 5) {
                if (result.isConfirmed) {
                    // Descargar certificado
                    descargarCertificado(calificacionRedondeada);
                } else if (result.isDismissed) {
                    // Redirigir al curso
                    window.location.href = `curso.php?cursoseleccionado=${cursoID}`;
                }
            } else {
                if (result.isDenied) {
                    // Reintentar cuestionario
                    reiniciarCuestionario();
                } else {
                    // Redirigir al curso
                    window.location.href = `curso.php?cursoseleccionado=${cursoID}`;
                }
            }

        } catch (error) {
            console.error('Error al calificar:', error);
            Swal.fire('Error', 'Ocurrió un error al procesar tu calificación', 'error');
        }
    }

   

    async function descargarCertificado(calificacion) {
        try {
            // Mostrar loader
            Swal.fire({
                title: 'Generando certificado',
                html: 'Por favor espere...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const response = await fetch('finalizar-curso.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest' // Identificar como AJAX
                },
                body: JSON.stringify({
                    accion: 'finalizar'
                })
            });

            const data = await response.json();

            if (!data.success) {
                throw new Error(data.error || 'Error al finalizar curso');
            }

            // 2. Luego generar el certificado
            const certResponse = await fetch(
                `../../../../controllers/generar_certificado.php?calificacion=${calificacion}&curso_id=${cursoID}`, {
                    method: 'GET'
                });

            if (!certResponse.ok) {
                const errorData = await certResponse.json();
                throw new Error(`Error al generar certificado: ${certResponse.status} - ${errorData.error}`);
            }

            // Procesar la respuesta del certificado
            const contentDisposition = certResponse.headers.get('Content-Disposition');
            let filename = `certificado_${new Date().toISOString().split('T')[0]}.pdf`;
            if (contentDisposition) {
                const filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                const matches = filenameRegex.exec(contentDisposition);
                if (matches != null && matches[1]) {
                    filename = matches[1].replace(/['"]/g, '');
                }
            }

            const blob = await certResponse.blob();
            const url = window.URL.createObjectURL(blob);

            // Descargar el certificado
            const a = document.createElement('a');
            a.href = url;
            a.download = filename;
            document.body.appendChild(a);
            a.click();

            // Limpieza
            window.URL.revokeObjectURL(url);
            a.remove();

            Swal.close();

            // Redirigir después de descargar
            setTimeout(() => {
                window.location.href = `../panel-curso/panel-curso.php`;
            }, 1000);

        } catch (error) {
            console.error('Error en el proceso:', error);
            Swal.fire('Error', `Hubo un problema: ${error.message}`, 'error');

            // En caso de error, redirigir igualmente
            setTimeout(() => {
                window.location.href = `../panel-curso/panel-curso.php`;
            }, 2000);
        }
    }



    // Función para reiniciar el cuestionario
    function reiniciarCuestionario() {
        // Limpiar selecciones
        preguntasGlobales.forEach((_, index) => {
            const selectedOption = document.querySelector(
                `input[name="pregunta-final-${index}"]:checked`);
            if (selectedOption) {
                selectedOption.checked = false;
            }
        });

        // Scroll al inicio
        window.scrollTo(0, 0);
    }

    // Obtener datos del curso
    fetch(`../../../../controllers/obtencionCuestionariosController.php?curso_id=${cursoID}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Error en la solicitud: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            console.log("Datos recibidos:", data);

            if (data && data.temario) {
                // Guardar preguntas globalmente
                preguntasGlobales = data.preguntas || [];

                // Mostrar título del curso
                if (data.curso_title) {
                    const tituloCurso = document.createElement("h1");
                    tituloCurso.className = "mb-4";
                    tituloCurso.textContent = data.curso_title;
                    container.prepend(tituloCurso);
                }

                // Mostrar cada tema del temario
                data.temario.forEach((tema, index) => {
                    try {
                        generarBloque(tema, index);
                    } catch (e) {
                        console.error("Error generando bloque:", e);
                    }
                });
            } else {
                container.innerHTML =
                    '<div class="alert alert-info">No se encontraron datos para este curso.</div>';
            }
        })
        .catch(error => {
            console.error('Error al obtener los datos:', error);
            container.innerHTML = '<div class="alert alert-danger">Error al cargar el contenido del curso.</div>';
        });
    </script>


</body>

</html>