<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuEmpleado.php');
$idusu = $_SESSION["usuario_id"];
?>




<style>
body {
    font-family: 'Poppins', sans-serif;
    background-color: #f0f4f8;
    color: #333;
    margin: 0;
    padding: 0;
}

.container {
    max-width: 1200px;
    margin: auto;
    padding: 2rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 2rem;
    text-align: center;
}

.course-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.course-card {
    background-color: #fff;
    border-radius: 1.5rem;
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
}

.course-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
}

.course-image {
    width: 100%;
    height: 200px;
    object-fit: cover;
}

.course-content {
    padding: 1.5rem;
}

.course-title {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #2c3e50;
}

.course-description {
    font-size: 1rem;
    color: #555;
    margin-bottom: 1.5rem;
    display: -webkit-box;
    /* Necesario para line-clamp */
    -webkit-line-clamp: 3;
    /* Número de líneas a mostrar */
    -webkit-box-orient: vertical;
    /* Necesario para line-clamp */
    overflow: hidden;
    /* Oculta el texto excedente */
}

.progress-bar-container {
    display: flex;
    align-items: center;
    margin-bottom: 1.5rem;
}

.progress {
    height: 0.8rem;
    border-radius: 0.4rem;
    background-color: #e9ecef;
    flex-grow: 1;
    margin-right: 1rem;
}

.progress-bar {
    background-color: #43a085;
}

.progress-text {
    font-size: 0.9rem;
    color: #6c757d;
}

.course-actions {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.btn-continue {
    background-color: #43a085;
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 0.5rem;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.btn-continue:hover {
    background-color: #36806a;
}

.course-info {
    font-size: 0.9rem;
    color: #6c757d;
}

/* Filter Styles */
.course-filters {
    display: flex;
    justify-content: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.filter-button {
    background-color: #fff;
    border: 1px solid #ccc;
    color: #555;
    padding: 0.5rem 1rem;
    border-radius: 0.5rem;
    cursor: pointer;
    transition: background-color 0.3s ease, color 0.3s ease, border-color 0.3s ease;
}

.filter-button.active {
    background-color: #43a085;
    color: white;
    border-color: #43a085;
}

.filter-button:hover {
    border-color: #aaa;
    color: #444;
}
</style>





<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">EMPLEADOS</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card p-3">
                    <h1 class="page-title">Mis Cursos en Progreso</h1>
                    <div class="course-grid">
                        <?php

                        $consulta = mysqli_query($conexion, "SELECT
    uc.usuario_id,
    u.nombre_completo,
    uc.curso_id,
    c.curso_title,
    c.curso_description,
    cat.titulo AS categoria_titulo,
    cat.url_img AS categoria_url_img,
    MAX(uc.intento) AS ultimo_intento, -- O MIN(uc.intento) si quieres el primero
    COUNT(uc.curso_id) AS total_intentos,
    MAX(uc.fecha_inscripcion) AS ultima_fecha_inscripcion, -- O MIN si quieres la primera
    MAX(uc.progreso) AS max_progreso,
    MAX(CASE WHEN uc.estado_curso = 'Completado' THEN 1 ELSE 0 END) AS curso_completado -- Indicador si alguna vez se completó
FROM
    usuarios_cursos uc
LEFT JOIN
    usuarios u ON u.usuario_id = uc.usuario_id
LEFT JOIN
    cursos c ON c.curso_id = uc.curso_id
LEFT JOIN
    categoria cat ON cat.categoria_id = c.categoria_id
WHERE
    uc.usuario_id = $idusu
GROUP BY
    uc.usuario_id, uc.curso_id, u.nombre_completo, c.curso_title, cat.titulo, cat.url_img;");
                        while ($row = mysqli_fetch_assoc($consulta)) {
                        ?>
                        <div class="course-card" data-category="desarrollo">
                            <img src="<?= $row['categoria_url_img'] ?>" alt="Categoria titulo" class="course-image">
                            <div class="course-content">
                                <h2 class="course-title"><?= $row["curso_title"] ?></h2>
                                <p class="course-description">
                                    <?= $row["curso_description"] ?>
                                </p>
                                <div class="progress-bar-container">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" style="width: 60%;"
                                            aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <span class="progress-text">60% Completado</span>
                                </div>
                                <div class="course-actions">
                                    <button class="btn-continue"
                                        data-curso-id="<?= $row['curso_id'] ?>">Continuar</button>
                                    <span class="course-info">12 Módulos</span>
                                </div>
                            </div>
                        </div>

                        <?php } ?>
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->



<script>
// Filter Functionality
const filterButtons = document.querySelectorAll('.filter-button');
const courseCards = document.querySelectorAll('.course-card');

filterButtons.forEach(button => {
    button.addEventListener('click', () => {
        const filter = button.dataset.filter;

        // Update active button state
        filterButtons.forEach(btn => btn.classList.remove('active'));
        button.classList.add('active');

        // Filter course cards
        courseCards.forEach(card => {
            if (filter === 'all' || card.dataset.category === filter) {
                card.style.display = 'block';
            } else {
                card.style.display = 'none';
            }
        });
    });
});

document.addEventListener('DOMContentLoaded', function() {
    const botonesContinuar = document.querySelectorAll('.btn-continue');

    botonesContinuar.forEach(boton => {
        boton.addEventListener('click', function() {
            const cursoId = this.getAttribute('data-curso-id');
            window.location.href =
                `../introduccion-curso/inicio-curso.php?cursoenproceso=${cursoId}`;
        });
    });
});
</script>


<?php require('../../components/FooterAdmin.php'); ?>