<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php'); ?>
<style>
.card .custom-card {
    border-radius: 0.25rem;
    background-color: var(--custom-white);
    box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
    border: 0;
    position: relative;
    margin-block-end: 1.5rem;
    width: 100%;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Contenidos de Cursos.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#nuevoContenidoModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Crear Contenido
                        </button>
                        <table id="dataTableContenido" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Titulo Temario</th>
                                    <th>Nombre del contenido</th>
                                    <th>Descripcion</th>
                                    <th>Tipo materia</th>
                                    <th>Ubicacion</th>
                                    <th>Duración</th>
                                    <th>Numero Pag</th>
                                    <th>Índice</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->

<!--
<div class="modal fade" id="nuevoContenidoModal" tabindex="-1" aria-labelledby="nuevoContenidoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white fw-bold" id="nuevoContenidoModalLabel">Ingresar Contenido</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formnuevocurso" method="post" enctype="multipart/form-data">
                    <div class="row">
                        - Búsqueda del título 
                        <div class="col-12 col-sm-4 mb-4">
                            <label for="searchInput">Seleccione Título del Temario</label>
                            <input type="text" id="searchInput" class="form-control mb-3" placeholder="Buscar..."
                                autocomplete="off">
                            <input type="" id="searchInputID" name="searchInputID">
                            <div id="results" style="max-height: 200px; overflow-y: auto;"></div>
                        </div>

                        Subtítulo
                        <div class="col-12 col-sm-4 mb-4">
                            <label for="nombrecontenidotext" class="form-label fw-bold">Subtítulo del contenido:</label>
                            <textarea name="nombrecontenidotext" id="nombrecontenidotext" class="form-control" rows="4"
                                style="resize: none;"></textarea>
                        </div>

                       Nivel 
                        <div class="col-12 col-sm-4 mb-4">
                            <label for="nivelSubtema">Nivel del subtema</label>
                            <input type="number" name="orden" id="nivelSubtema" class="form-control" min="1" max="10"
                                value="1">
                        </div>
                    </div>

                   Descripción del contenido 
                    <div class="row">
                        <div id="editor" style="height: 300px;">
                            <p>Escribe la descripción del Contenido...</p>
                        </div>
                        <textarea name="contentarea" id="contentarea" class=""></textarea>
                    </div>

                     Tipo y archivos 
                    <div class="row mb-3">
                        <div class="col-12 col-sm-6">
                            <label for="archivo_material" class="form-label">Selecciona los archivos</label>
                            <input type="file" id="archivo_material" name="archivo_material[]" class="form-control"
                                multiple>
                            <small class="form-text text-muted">Puedes subir varios archivos de cualquier tipo (PDF,
                                Word, Video, Imagen, etc.).</small>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Guardar contenido</button>
                </form>


            </div>
        </div>
    </div>
</div>
-->
<div class="modal fade" id="nuevoContenidoModal" tabindex="-1" aria-labelledby="nuevoContenidoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con icono educativo -->
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <i class="fas fa-book-open me-3 fs-4"></i>
                    <h5 class="modal-title fw-bold mb-0" id="nuevoContenidoModalLabel">Nuevo Contenido de Curso</h5>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-4">
                <form id="formnuevocurso" method="post" enctype="multipart/form-data">
                    <!-- Sección 1: Información Básica -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-info-circle me-2"></i>Información Básica
                        </div>
                        <div class="card-body">
                            <div class="row g-4">
                                <!-- Búsqueda del título -->
                                <div class="col-md-4">
                                    <label for="searchInput" class="form-label fw-semibold">
                                        <i class="fas fa-search me-2"></i>Título del Temario
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-book"></i>
                                        </span>
                                        <input type="text" id="searchInput" class="form-control"
                                            placeholder="Buscar título..." autocomplete="off">
                                    </div>
                                    <input type="hidden" id="searchInputID" name="searchInputID">
                                    <div id="results" class="list-group mt-2 shadow-sm"
                                        style="max-height: 200px; overflow-y: auto;"></div>
                                </div>

                                <!-- Subtítulo -->
                                <div class="col-md-4">
                                    <label for="nombrecontenidotext" class="form-label fw-semibold">
                                        <i class="fas fa-heading me-2"></i>Subtítulo/Nombre
                                    </label>
                                    <textarea name="nombrecontenidotext" id="nombrecontenidotext" class="form-control"
                                        rows="4" style="resize: none;"
                                        placeholder="Ej: Introducción a la programación..."></textarea>
                                </div>

                                <!-- Nivel -->
                                <div class="col-md-4">
                                    <label for="nivelSubtema" class="form-label fw-semibold">
                                        <i class="fas fa-layer-group me-2"></i>Nivel del Contenido
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-sort-numeric-up"></i>
                                        </span>
                                        <input type="number" name="orden" id="nivelSubtema" class="form-control" min="1"
                                            max="10" value="1" placeholder="1-10">
                                    </div>
                                    <small class="text-muted">Indica la prioridad/orden de este contenido</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 2: Descripción -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-align-left me-2"></i>Descripción Detallada
                        </div>
                        <div class="card-body">
                            <div id="editor"
                                style="height: 250px; border-radius: 5px; border: 1px solid #dee2e6; padding: 10px;">
                                <p>Escribe aquí la descripción completa del contenido del curso...</p>
                            </div>
                            <textarea name="contentarea" id="contentarea" class="d-none"></textarea>
                        </div>
                    </div>

                    <!-- Sección 3: Materiales -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-paperclip me-2"></i>Materiales de Apoyo
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <label for="archivo_material" class="form-label fw-semibold">
                                        <i class="fas fa-file-upload me-2"></i>Subir Archivos
                                    </label>
                                    <div class="input-group">
                                        <input type="file" id="archivo_material" name="archivo_material[]"
                                            class="form-control" multiple>
                                        <button class="btn btn-outline-primary" type="button">
                                            <i class="fas fa-folder-open"></i>
                                        </button>
                                    </div>
                                    <div class="mt-2">
                                        <span class="badge bg-primary me-2">
                                            <i class="fas fa-file-pdf"></i> PDF
                                        </span>
                                        <span class="badge bg-success me-2">
                                            <i class="fas fa-file-word"></i> Word
                                        </span>
                                        <span class="badge bg-danger me-2">
                                            <i class="fas fa-file-video"></i> Video
                                        </span>
                                        <span class="badge bg-info">
                                            <i class="fas fa-file-image"></i> Imagen
                                        </span>
                                    </div>
                                    <small class="text-muted">Puedes seleccionar múltiples archivos (tamaño máximo:
                                        50MB)</small>
                                </div>
                                <div class="col-md-4 d-flex align-items-end">
                                    <div class="w-100">
                                        <button type="submit" class="btn btn-primary w-100 py-2 fw-bold">
                                            <i class="fas fa-save me-2"></i>Guardar Contenido
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Pie de modal -->
            <div class="modal-footer bg-light">
                <small class="text-muted me-auto">
                    <i class="fas fa-info-circle me-1"></i> Todos los campos son obligatorios
                </small>
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Cancelar
                </button>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>


<script>
//CRIPT PARA LA BUSQUEDA DE USUARIOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../../controllers/searchTituloTemarioController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.ID_Titulo}" data-name="${item.nom_titulo_temario}">
                                <strong>${item.nom_titulo_temario}</strong><br>
                                <small>${item.TITULO_CURSO}</small>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});



$(document).ready(function() {
    if ($.fn.DataTable.isDataTable('#dataTableContenido')) {
        $('#dataTableContenido').DataTable().clear().destroy();
    }

    $('#dataTableContenido').DataTable({
        "processing": true,
        "serverSide": true,
        "responsive": true,
        "ajax": {
            "url": "../../../../controllers/obtenerContenidoCursos.php",
            "type": "GET",
            "dataSrc": function(json) {
                if (json.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al cargar los datos',
                        text: json.error
                    });
                    return [];
                }
                //console.log(json.data);
                return json.data;
            }
        },
        "columns": [{
                "data": "id_Contenido"
            },
            {
                "data": "nom_titulo_temario"
            },
            {
                "data": "nombre_contenido"
            },
            {
                "data": "descripcion_contenido"
            },
            {
                "data": "tipo_material"
            },
            {
                "data": "ubicacion_material"
            },
            {
                "data": "duracion_video"
            },
            {
                "data": "numero_paginas_PDF"
            },
            {
                "data": "Orden"
            },

            {
                "data": null,
                "render": function(data, type, row) {
                    return `
                        <button class="btn btn-sm btn-warning me-1 btnEditar" data-id="${row.detalle_id}">
                            <i class="bi bi-pencil"></i> Editar
                        </button>
                        <button class="btn btn-sm btn-danger btnEliminar" data-id="${row.detalle_id}">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    `;
                }
            }
        ],
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "No hay datos disponibles",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sPrevious": "Anterior",
                "sNext": "Siguiente",
                "sLast": "Último"
            }
        },
        "paging": true,
        "pageLength": 10,
        "lengthChange": true,
        "info": true,
        "autoWidth": false
    });

    // Acciones con delegación de eventos
    $('#dataTableDetallesCurso tbody').on('click', '.btnEditar', function() {
        const id = $(this).data('id');
        // Aquí puedes abrir un modal o redirigir
        console.log("Editar curso con ID:", id);
        Swal.fire("Editar", "Aquí abrirías el modal para editar ID " + id, "info");
    });

    $('#dataTableDetallesCurso tbody').on('click', '.btnEliminar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "Esta acción no se puede deshacer.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '../../../controllers/eliminarDetalleCursoController.php',
                    type: 'POST',
                    data: {
                        id: id
                    },
                    success: function(response) {
                        const res = JSON.parse(response);
                        if (res.success) {
                            Swal.fire('Eliminado', res.message, 'success');
                            $('#dataTableDetallesCurso').DataTable().ajax.reload(
                                null, false);
                        } else {
                            Swal.fire('Error', res.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'No se pudo conectar con el servidor.',
                            'error');
                    }
                });
            }
        });
    });
});

$(document).ready(function() {

    var quill = new Quill('#editor', {
        theme: 'snow', // Tema "snow" para una interfaz limpia
        modules: {
            toolbar: [
                ['bold', 'italic', 'underline', 'strike'], // Formato básico
                ['blockquote', 'code-block'], // Bloques
                [{
                    'header': [1, 2, 3, false]
                }], // Encabezados
                [{
                    'list': 'ordered'
                }, {
                    'list': 'bullet'
                }], // Listas
                [{
                    'indent': '-1'
                }, {
                    'indent': '+1'
                }], // Indentación
                [{
                    'align': []
                }], // Alineación
                ['link'] // Enlaces
            ]
        }
    });
    quill.on('text-change', function() {
        document.querySelector('#contentarea').value = quill.root.innerHTML;
    })





});
document.getElementById('formnuevocurso').addEventListener('submit', async function(e) {
    e.preventDefault();

    // Mostrar loader
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Procesando...';
    submitBtn.disabled = true;

    try {
        const formData = new FormData(this);

        // Verificar si hay archivos de video seleccionados
        const fileInput = this.querySelector('input[type="file"]');
        if (fileInput.files.length > 0) {
            for (let i = 0; i < fileInput.files.length; i++) {
                const file = fileInput.files[i];
                console.log(`Archivo ${i+1}:`, file.name, file.type, file.size);

                // Validación básica en el cliente (opcional)
                if (file.size > 800 * 1024 * 1024) { // 500MB
                    throw new Error(`El archivo ${file.name} excede el tamaño máximo permitido (500MB)`);
                }

                const videoTypes = ['video/mp4', 'video/quicktime', 'video/x-msvideo'];
                if (!videoTypes.includes(file.type) && !file.name.match(/\.(mp4|mov|avi|pdf)$/i)) {
                    console.warn(`El archivo ${file.name} puede no ser un video válido`);
                }
            }
        }

        // Configuración de la petición fetch
        const response = await fetch('https://marjetactivity.com.mx/cursos-promotoria/src/controllers/registroContenidoController.php', {
            method: 'POST',
            body: formData,
        });

        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }

        // Depurar la respuesta como texto
        const responseText = await response.text();
        console.log("Respuesta del servidor:", responseText);

        // Intentar convertir a JSON
        try {
            const data = JSON.parse(responseText);
            if (data.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    html: `${data.message}<br><br>Archivos procesados: ${data.data?.archivos?.filter(a => a.status === 'success').length || 0}`,
                    confirmButtonText: 'Aceptar'
                }).then(() => {
                    // Recargar o redirigir después de éxito
                    window.location.reload();
                });
            } else {
                let errorMessage = data.message;

                // Procesar errores de archivos si existen
                if (data.data?.archivos) {
                    const erroresArchivos = data.data.archivos.filter(a => a.status === 'error');
                    if (erroresArchivos.length > 0) {
                        errorMessage += '<br><br>Errores en archivos:';
                        erroresArchivos.forEach(archivo => {
                            errorMessage += `<br>• ${archivo.file}: ${archivo.message}`;
                        });
                    }
                }

                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    html: errorMessage,
                    confirmButtonText: 'Aceptar'
                });
            }
        } catch (jsonError) {
            console.error('Error al parsear JSON:', jsonError);
            Swal.fire({
                icon: 'error',
                title: '¡Error!',
                text: 'El servidor devolvió una respuesta no válida.',
                confirmButtonText: 'Aceptar'
            });
        }
        
    } catch (error) {
        console.error('Error en la solicitud:', error);
        Swal.fire({
            icon: 'error',
            title: '¡Error!',
            text: error.message || 'Hubo un problema al procesar la solicitud.',
            confirmButtonText: 'Aceptar'
        });
    } finally {
        // Restaurar botón
        submitBtn.innerHTML = originalBtnText;
        submitBtn.disabled = false;
    }
});

</script>






<?php require('../../components/FooterAdmin.php'); ?>