<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php');
?>
<style>
.card .custom-card {
    border-radius: 0.25rem;
    background-color: var(--custom-white);
    box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
    border: 0;
    position: relative;
    margin-block-end: 1.5rem;
    width: 100%;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detalles Curso</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#detallesCursoModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Añadir Detalles a Curso
                        </button>
                        <table id="dataTableDetallesCurso" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nombre Curso</th>
                                    <th>Objetivos</th>
                                    <th>Audiencia</th>
                                    <th>Requisitos</th>
                                    <th>Modalidad</th>
                                    <th>Evaluación</th>
                                    <th>Creado</th>
                                    <th>Actualización</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->


<!-- <div class="modal fade" id="detallesCursoModal" tabindex="-1" aria-labelledby="detallesCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white fw-bold" id="detallesCursoModalLabel">Detalles Curso</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formdetallescurso">
                    <div class="row">
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="nombre">Seleccione Curso</label>
                                <input type="text" id="searchInput" class="form-control mb-3" placeholder="Buscar..."
                                    autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false"
                                    style="width: 100%;">
                                <input type="hidden" id="searchInputID" name="searchInputID">
                                <div id="results" style="max-height: 200px; overflow-y: auto;"></div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <label for="audienciaobjetivotext" class="form-label fw-bold">Audiencia Objetivo:</label>
                            <textarea name="audienciaobjetivotext" id="audienciaobjetivotext" class="form-control"
                                rows="4" style="border-radius: 5px; padding: 10px; resize: none;"></textarea>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <label for="requisitostext" class="form-label fw-bold">Requisitos Previos:</label>
                            <textarea name="requisitostext" id="requisitostext" class="form-control" rows="4"
                                style="border-radius: 5px; padding: 10px; resize: none;"></textarea>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="nombre_emp" class="form-label">
                                    Modalidad
                                </label>
                                <input type="text" class="form-control" id="modalidadtext" name="modalidadtext"
                                    required>
                            </div>
                        </div>


                    </div>
                    <div class="row">

                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="nombre_emp" class="form-label fw-bold">
                                    Evaluación
                                </label>
                                <input type="text" class="form-control" id="evaluaciontext" name="evaluaciontext"
                                    required>
                            </div>

                        </div>
                        <div id="editor" style="height: 300px;">
                            <p>Escribe los objetivos del curso...</p>
                        </div>
                        <textarea class="hidden" name="contentarea" id="contentarea"></textarea>

                    </div>

                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="submit" id="guardardetallescurso" class="btn btn-primary">Guardar Datos</button>
            </div>

        </div>
    </div>
</div> -->

<div class="modal fade" id="detallesCursoModal" tabindex="-1" aria-labelledby="detallesCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con estilo educativo -->
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <i class="fas fa-info-circle me-3 fs-4"></i>
                    <h5 class="modal-title fw-bold mb-0" id="detallesCursoModalLabel">Detalles del Curso</h5>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-4">
                <form id="formdetallescurso">
                    <!-- Sección 1: Información Básica -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-search me-2"></i>Selección del Curso
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Búsqueda de curso -->
                                <div class="col-md-3">
                                    <label for="searchInput" class="form-label fw-semibold">
                                        <i class="fas fa-book me-2"></i>Buscar Curso
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-search"></i>
                                        </span>
                                        <input type="text" id="searchInput" class="form-control"
                                            placeholder="Escribe para buscar..." autocomplete="off" autocorrect="off"
                                            autocapitalize="off" spellcheck="false">
                                    </div>
                                    <input type="hidden" id="searchInputID" name="searchInputID">
                                    <div id="results" class="list-group mt-2 shadow-sm"
                                        style="max-height: 200px; overflow-y: auto;"></div>
                                </div>

                                <!-- Modalidad -->
                                <div class="col-md-3">
                                    <label for="modalidadtext" class="form-label fw-semibold">
                                        <i class="fas fa-laptop-house me-2"></i>Modalidad
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-chalkboard-teacher"></i>
                                        </span>
                                        <input type="text" class="form-control" id="modalidadtext" name="modalidadtext"
                                            required placeholder="Ej: Virtual, Presencial...">
                                    </div>
                                </div>

                                <!-- Evaluación -->
                                <div class="col-md-3">
                                    <label for="evaluaciontext" class="form-label fw-semibold">
                                        <i class="fas fa-clipboard-check me-2"></i>Evaluación
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-star-half-alt"></i>
                                        </span>
                                        <input type="text" class="form-control" id="evaluaciontext"
                                            name="evaluaciontext" required placeholder="Tipo de evaluación">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 2: Audiencia y Requisitos -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-users me-2"></i>Público y Requisitos
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Audiencia Objetivo -->
                                <div class="col-md-6">
                                    <label for="audienciaobjetivotext" class="form-label fw-semibold">
                                        <i class="fas fa-user-graduate me-2"></i>Audiencia Objetivo
                                    </label>
                                    <textarea name="audienciaobjetivotext" id="audienciaobjetivotext"
                                        class="form-control" rows="4"
                                        style="border-radius: 5px; padding: 10px; resize: none;"
                                        placeholder="¿A quién está dirigido este curso?"></textarea>
                                </div>

                                <!-- Requisitos Previos -->
                                <div class="col-md-6">
                                    <label for="requisitostext" class="form-label fw-semibold">
                                        <i class="fas fa-tasks me-2"></i>Requisitos Previos
                                    </label>
                                    <textarea name="requisitostext" id="requisitostext" class="form-control" rows="4"
                                        style="border-radius: 5px; padding: 10px; resize: none;"
                                        placeholder="¿Qué conocimientos previos se necesitan?"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 3: Objetivos -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-bullseye me-2"></i>Objetivos del Curso
                        </div>
                        <div class="card-body">
                            <div id="editor"
                                style="height: 250px; border-radius: 5px; border: 1px solid #dee2e6; padding: 10px;">
                                <p>Describe los objetivos de aprendizaje de este curso...</p>
                            </div>
                            <textarea class="d-none" name="contentarea" id="contentarea"></textarea>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Pie de modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Cancelar
                </button>
                <button type="submit" id="guardardetallescurso" class="btn btn-primary">
                    <i class="fas fa-save me-1"></i> Guardar Detalles
                </button>
            </div>
        </div>
    </div>
</div>




<!-- Carga de SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    if ($.fn.DataTable.isDataTable('#dataTableDetallesCurso')) {
        $('#dataTableDetallesCurso').DataTable().clear().destroy();
    }

    $('#dataTableDetallesCurso').DataTable({
        "processing": true,
        "serverSide": true,

        "ajax": {
            "url": "../../../../controllers/obtenerDetallesCursosControllerUsuario.php",
            "type": "GET",
            "dataSrc": function(json) {
                if (json.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al cargar los datos',
                        text: json.error
                    });
                    return [];
                }
                //console.log(json.data);
                return json.data;
            }
        },
        "columns": [{
                "data": "detalle_id"
            },
            {
                "data": "curso_title"
            },
            {
                "data": "objetivos_aprendizaje"
            },
            {
                "data": "audiencia_objetivo"
            },
            {
                "data": "requisitos_previos"
            },
            {
                "data": "modalidad"
            },
            {
                "data": "evaluacion"
            },
            {
                "data": "created_at"
            },
            {
                "data": "updated_at"
            },
            {
                "data": null,
                "render": function(data, type, row) {
                    return `
                        <button class="btn btn-sm btn-warning me-1 btnEditar" data-id="${row.detalle_id}">
                            <i class="bi bi-pencil"></i> Editar
                        </button>
                        <button class="btn btn-sm btn-danger btnEliminar" data-id="${row.detalle_id}">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    `;
                }
            }
        ],
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "No hay datos disponibles",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sPrevious": "Anterior",
                "sNext": "Siguiente",
                "sLast": "Último"
            }
        },
        "paging": true,
        "pageLength": 10,
        "lengthChange": true,
        "info": true,
        "autoWidth": false
    });

    // Acciones con delegación de eventos
    $('#dataTableDetallesCurso tbody').on('click', '.btnEditar', function() {
        const id = $(this).data('id');
        // Aquí puedes abrir un modal o redirigir
        console.log("Editar curso con ID:", id);
        Swal.fire("Editar", "Aquí abrirías el modal para editar ID " + id, "info");
    });

    $('#dataTableDetallesCurso tbody').on('click', '.btnEliminar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "Esta acción no se puede deshacer.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '../../../controllers/eliminarDetalleCursoController.php',
                    type: 'POST',
                    data: {
                        id: id
                    },
                    success: function(response) {
                        const res = JSON.parse(response);
                        if (res.success) {
                            Swal.fire('Eliminado', res.message, 'success');
                            $('#dataTableDetallesCurso').DataTable().ajax.reload(
                                null, false);
                        } else {
                            Swal.fire('Error', res.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'No se pudo conectar con el servidor.',
                            'error');
                    }
                });
            }
        });
    });
});
</script>
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
//SCRIPT PARA LA BUSQUEDA DE USUARIOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../../controllers/searchUsuariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.curso_id}" data-name="${item.curso_title}">
                                <strong>${item.curso_title}</strong><br>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});



$(document).ready(function() {

    var quill = new Quill('#editor', {
        theme: 'snow', // Tema "snow" para una interfaz limpia
        modules: {
            toolbar: [
                ['bold', 'italic', 'underline', 'strike'], // Formato básico
                ['blockquote', 'code-block'], // Bloques
                [{
                    'header': [1, 2, 3, false]
                }], // Encabezados
                [{
                    'list': 'ordered'
                }, {
                    'list': 'bullet'
                }], // Listas
                [{
                    'indent': '-1'
                }, {
                    'indent': '+1'
                }], // Indentación
                [{
                    'align': []
                }], // Alineación
                ['link'] // Enlaces
            ]
        }
    });
    quill.on('text-change', function() {
        document.querySelector('#contentarea').value = quill.root.innerHTML;
    })

    $('#guardardetallescurso').click(function() {
        // Validar el formulario
        if ($('#formdetallescurso')[0].checkValidity()) {


            const formData = {
                id_curso: $('#searchInputID').val(),
                audiencia: $('#audienciaobjetivotext').val(),
                requisitos: $('#requisitostext').val(),
                modalidad: $('#modalidadtext').val(),
                evaluacion: $('#evaluaciontext').val(),
                objetivos: $('#contentarea').val(),
            };

            // Enviar datos con AJAX
            $.ajax({
                url: '../../../../controllers/registroDetallesCursoController.php',
                type: 'POST',
                data: formData,
                success: function(response) {
                    const result = JSON.parse(response);
                    if (result.status === "success") {
                        Swal.fire({
                            icon: 'success',
                            title: 'Éxito',
                            text: result.message,
                        }).then(() => {
                            $('#formdetallescurso').modal('hide');
                            location.reload();
                        });

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: result.message,
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error de conexión',
                        text: 'No se pudo conectar al servidor. Inténtelo de nuevo más tarde.',
                    });
                },
            });
        } else {
            // Mostrar errores de validación
            $('#formdetallescurso')[0].reportValidity();
        }
    });
});
</script>


<?php require('../../components/FooterAdmin.php'); ?>