<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php'); ?>
<style>
    .card .custom-card {
        border-radius: 0.25rem;
        background-color: var(--custom-white);
        box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
        border: 0;
        position: relative;
        margin-block-end: 1.5rem;
        width: 100%;
    }

    /* Opcional: Estilo para el contenedor de resultados */
    .result-container {
        position: absolute;
        width: calc(100% - 1rem);
        /* Ajuste fino del ancho */
        max-height: 250px;
        overflow-y: auto;
        z-index: 1000;
        background: #ffffff;
        border: 1px solid #e0e0e0;
        border-radius: 0.375rem;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        margin-top: 0.25rem;
        display: none;
        transition: all 0.3s ease;
    }

    /* Scrollbar personalizada (elegante) */
    .result-container::-webkit-scrollbar {
        width: 8px;
    }

    .result-container::-webkit-scrollbar-track {
        background: #f8f9fa;
        border-radius: 0 0.375rem 0.375rem 0;
    }

    .result-container::-webkit-scrollbar-thumb {
        background: #ced4da;
        border-radius: 4px;
    }

    .result-container::-webkit-scrollbar-thumb:hover {
        background: #adb5bd;
    }

    /* Items de resultados */
    .result-item {
        padding: 0.75rem 1rem;
        border-bottom: 1px solid #f0f0f0;
        color: #495057;
        font-size: 0.925rem;
        transition: all 0.2s ease;
        cursor: pointer;
        text-decoration: none;
        display: block;
    }

    .result-item:last-child {
        border-bottom: none;
    }

    .result-item:hover {
        background-color: #f8f9fa;
        color: #2c3e50;
    }

    .result-item:active {
        background-color: #e9ecef;
    }

    /* Estado de carga */
    .loading-item {
        padding: 1rem;
        text-align: center;
        color: #6c757d;
        font-size: 0.875rem;
    }

    /* Mensaje sin resultados */
    .no-results-item {
        padding: 1rem;
        text-align: center;
        color: #6c757d;
        font-style: italic;
        font-size: 0.875rem;
    }

    /* Mensaje de error */
    .error-item {
        padding: 1rem;
        text-align: center;
        color: #dc3545;
        font-size: 0.875rem;
    }

    /* Estilos para los encabezados de tabla mejorados */
    .header-gradient {

        color: black !important;
        text-transform: uppercase;
        font-weight: 600;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        padding: 15px 10px !important;
        position: relative;
        border: none !important;
        text-shadow: 0 1px 1px rgba(0, 0, 0, 0.2);
        transition: all 0.3s ease;
    }

    .header-gradient:hover {

        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .header-gradient::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 80%;
        height: 2px;
        background: rgba(255, 255, 255, 0.3);
    }

    /* Efecto para ordenación (si usas sorting) */
    .header-gradient.sorting:after,
    .header-gradient.sorting_asc:after,
    .header-gradient.sorting_desc:after {
        content: '↑↓';
        font-family: 'Arial', sans-serif;
        position: absolute;
        right: 8px;
        color: rgba(255, 255, 255, 0.7);
        font-size: 0.9rem;
    }

    .header-gradient.sorting_asc:after {
        content: '↑';
        color: white;
    }

    .header-gradient.sorting_desc:after {
        content: '↓';
        color: white;
    }

    /* Ajuste para columnas específicas */
    th.header-gradient:first-child {
        border-radius: 10px 0 0 10px !important;
    }

    th.header-gradient:last-child {
        border-radius: 0 10px 10px 0 !important;
    }

    /**ESTILOS MODALES */
    .modal-header {
        background-color: #2c3e50;
        color: white;
        border-bottom: none;
    }

    .modal-content {
        border-radius: 0.5rem;
        border: none;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .form-label {
        font-weight: 500;
        color: #34495e;
    }

    .form-control,
    .form-select {
        border-radius: 0.25rem;
        border: 1px solid #ced4da;
        padding: 0.5rem 0.75rem;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #3498db;
        box-shadow: 0 0 0 0.25rem rgba(52, 152, 219, 0.25);
    }

    .btn-primary {
        background-color: #3498db;
        border: none;
        padding: 0.5rem 1.5rem;
        border-radius: 0.25rem;
    }

    .btn-primary:hover {
        background-color: #2980b9;
    }

    .search-dropdown {
        position: relative;
    }

    .search-results {
        position: absolute;
        width: 100%;
        max-height: 200px;
        overflow-y: auto;
        z-index: 1000;
        background: white;
        border: 1px solid #ddd;
        border-radius: 0 0 4px 4px;
        display: none;
    }

    .search-item {
        padding: 8px 12px;
        cursor: pointer;
    }

    .search-item:hover {
        background-color: #f8f9fa;
    }

    .required-field::after {
        content: "*";
        color: #e74c3c;
        margin-left: 4px;
    }

    .error-message {
        color: #e74c3c;
        font-size: 0.875rem;
        margin-top: 0.25rem;
        display: none;
    }

    #modalEditarUsuario .btn-close {
        filter: invert(1) grayscale(100%) brightness(200%);
        /* Opcional: ajustar tamaño o posición */
        /* opacity: 1; */
    }
</style>


<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card shadow-header">
                    <div class="card-header">
                        <h3 class="card-title">Usuarios.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#crearUsuarioModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Crear Nuevo Usuario
                        </button>
                        <table id="dataTableEmpleados" class="table table-hover table-borderless mb-0">
                            <thead>
                                <tr>
                                    <th class="text-center header-gradient">ID</th>
                                    <th class="header-gradient" width="10%">NOMBRE</th>
                                    <th class="header-gradient" width="8%">RFC</th>
                                    <th class="header-gradient">CURP</th>
                                    <th class="header-gradient" width="5%">EMAIL</th>
                                    <th class="header-gradient">ESTADO</th>
                                    <th class="header-gradient">PROMOTORIA</th>
                                    <th class="header-gradient">PUESTO</th>
                                    <th class="header-gradient">ROL</th>
                                    <th class="text-center header-gradient">ESTATUS</th>
                                    <th class="header-gradient" width="8%">FECHA INGRESO</th>
                                    <th class="header-gradient">CREADO</th>
                                    <th class="header-gradient">ACTUALIZADO</th>
                                    <th class="header-gradient">ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->

<!-- Modal -->
<div class="modal fade" id="crearUsuarioModal" tabindex="-1" aria-labelledby="crearUsuarioModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="crearUsuarioModalLabel"><i class="fas fa-user-plus me-2"></i>Crear Nuevo
                    Usuario</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formCrearUsuario" action="../../../../controllers/guardarUsuarioController.php" novalidate>
                    <div class="row g-3">
                        <!-- Columna Izquierda -->
                        <div class="col-md-6">
                            <!-- Nombre -->
                            <div class="mb-3">
                                <label for="nombre" class="form-label required-field">Nombre completo</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" required>
                                <div class="error-message" id="nombre-error">Por favor ingrese el nombre completo</div>
                            </div>

                            <!-- RFC -->
                            <div class="mb-3">
                                <label for="rfc" class="form-label required-field">RFC</label>
                                <input type="text" class="form-control" id="rfc" name="rfc"
                                    placeholder="Ej. XAXX010101000" maxlength="13" required>
                                <div class="error-message" id="rfc-error">Ingrese un RFC válido (12-13 caracteres)</div>
                                <small class="text-muted">Formato: 12-13 caracteres alfanuméricos</small>
                            </div>

                            <!-- CURP -->
                            <div class="mb-3">
                                <label for="curp" class="form-label required-field">CURP</label>
                                <input type="text" class="form-control" id="curp" name="curp"
                                    placeholder="Ej. XAXX010101HDFXXX00" maxlength="18" required>
                                <div class="error-message" id="curp-error">Ingrese una CURP válida (18 caracteres)</div>
                            </div>

                            <!-- Email -->
                            <div class="mb-3">
                                <label for="email" class="form-label required-field">Correo electrónico</label>
                                <input type="email" class="form-control" id="email" name="email"
                                    placeholder="usuario@empresa.com" required>
                                <div class="error-message" id="email-error">Ingrese un correo electrónico válido</div>
                            </div>
                            <div class="mb-3 position-relative">
                                <label for="password" class="form-label required-field">Contraseña</label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="password" name="password"
                                        placeholder="Ingrese su contraseña" required
                                        pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$">
                                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <div class="error-message" id="password-error">
                                    La contraseña debe tener al menos 8 caracteres, incluyendo mayúsculas, minúsculas,
                                    números y caracteres especiales
                                </div>
                                <small class="text-muted">
                                    Mínimo 8 caracteres con mayúsculas, minúsculas, números y caracteres especiales
                                    (@$!%*?&)
                                </small>
                            </div>
                        </div>

                        <!-- Columna Derecha -->
                        <div class="col-md-6">
                            <!-- Estado -->
                            <div class="mb-3">
                                <label for="estado" class="form-label required-field">Estado</label>
                                <select class="form-select" id="estado" name="estado" required>
                                    <option value="" selected disabled>Seleccione un estado</option>
                                    <option value="AGS">Aguascalientes</option>
                                    <option value="BC">Baja California</option>
                                    <option value="BCS">Baja California Sur</option>
                                    <option value="CAMP">Campeche</option>
                                    <option value="CHIS">Chiapas</option>
                                    <option value="CHIH">Chihuahua</option>
                                    <option value="COAH">Coahuila</option>
                                    <option value="COL">Colima</option>
                                    <option value="CDMX">Ciudad de México</option>
                                    <option value="DGO">Durango</option>
                                    <option value="GTO">Guanajuato</option>
                                    <option value="GRO">Guerrero</option>
                                    <option value="HGO">Hidalgo</option>
                                    <option value="JAL">Jalisco</option>
                                    <option value="EDOMEX">Estado de México</option>
                                    <option value="MICH">Michoacán</option>
                                    <option value="MOR">Morelos</option>
                                    <option value="NAY">Nayarit</option>
                                    <option value="N.L">Nuevo León</option>
                                    <option value="OAX">Oaxaca</option>
                                    <option value="PUE">Puebla</option>
                                    <option value="QRO">Querétaro</option>
                                    <option value="QROO">Quintana Roo</option>
                                    <option value="SLP">San Luis Potosí</option>
                                    <option value="SIN">Sinaloa</option>
                                    <option value="SON">Sonoma</option>
                                    <option value="TAB">Tabasco</option>
                                    <option value="TAMPS">Tamaulipas</option>
                                    <option value="TLAX">Tlaxcala</option>
                                    <option value="VER">Veracruz</option>
                                    <option value="YUC">Yucatán</option>
                                    <option value="ZAC">Zacatecas</option>
                                </select>
                                <div class="error-message" id="estado-error">Seleccione un estado</div>
                            </div>

                            <!-- Promotoria (Búsqueda) -->
                            <div class="mb-3 search-dropdown position-relative">
                                <label for="searchPromotoria" class="form-label fw-semibold">
                                    <i class="fas fa-users me-2"></i>Promotoría
                                </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-primary text-white"><i
                                            class="fas fa-search"></i></span>
                                    <input type="text" id="searchPromotoria" class="form-control search-input"
                                        placeholder="Buscar promotoria..."
                                        data-url="../../../../controllers/searchPromotoriasController.php"
                                        data-hidden="promotoriaID" autocomplete="off">
                                </div>
                                <input type="hidden" id="promotoriaID" name="promotoriaID">
                                <div class="list-group mt-2 shadow-sm result-container"
                                    style="max-height: 200px; overflow-y: auto; display: none;"></div>


                                <div class="error-message" id="promotoria-error">Seleccione una promotoría válida</div>
                            </div>

                            <!-- Puesto (Búsqueda) -->
                            <div class="mb-3 search-dropdown">
                                <label for="searchPuesto" class="form-label fw-semibold">
                                    <i class="fas fa-briefcase me-2"></i>Puesto
                                </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-primary text-white"><i
                                            class="fas fa-search"></i></span>
                                    <input type="text" id="searchPuesto" class="form-control search-input"
                                        placeholder="Buscar puesto..."
                                        data-url="../../../../controllers/searchPuestosController.php"
                                        data-hidden="puestoID" autocomplete="off">
                                </div>
                                <input type="hidden" id="puestoID" name="puestoID">
                                <div class="list-group mt-2 shadow-sm result-container"
                                    style="max-height: 200px; overflow-y: auto; display: none;"></div>

                                <div class="error-message" id="puesto-error">Seleccione un puesto válido</div>
                            </div>

                            <!-- Input de Rol corregido -->
                            <div class="mb-3 search-dropdown">
                                <label for="searchRol" class="form-label fw-semibold">
                                    <i class="fas fa-user-tag me-2"></i>Rol
                                </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text bg-primary text-white"><i
                                            class="fas fa-search"></i></span>
                                    <input type="text" id="searchRol" class="form-control search-input"
                                        placeholder="Buscar rol..."
                                        data-url="../../../../controllers/searchRolesController.php" data-hidden="rolID"
                                        autocomplete="off">
                                </div>
                                <input type="hidden" id="rolID" name="rolID">
                                <div class="list-group mt-2 shadow-sm result-container"
                                    style="max-height: 200px; overflow-y: auto; display: none;"></div>
                                <div class="error-message" id="rol-error">Seleccione un rol válido</div>
                            </div>

                            <!-- Estatus -->
                            <div class="mb-3">
                                <label for="estatus" class="form-label required-field">Estatus</label>
                                <select class="form-select" id="estatus" name="estatus" required>
                                    <option value="" selected disabled>Seleccione un estatus</option>
                                    <option value="ACTIVO">Activo</option>
                                    <option value="INACTIVO">Inactivo</option>
                                </select>
                                <div class="error-message" id="estatus-error">Seleccione un estatus</div>
                            </div>

                            <!-- Fecha Ingreso -->
                            <div class="mb-3">
                                <label for="fecha_ingreso" class="form-label required-field">Fecha de ingreso</label>
                                <input type="date" class="form-control" id="fecha_ingreso" name="fecha_ingreso"
                                    required>
                                <div class="error-message" id="fecha_ingreso-error">Ingrese una fecha válida</div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i
                        class="fas fa-times me-1"></i> Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnGuardarUsuario"><i class="fas fa-save me-1"></i>
                    Guardar Usuario</button>
            </div>
            <div id="alerts-container" class="mt-2"></div>
        </div>
    </div>
</div>

<!-- Modal de Edición de Usuario -->
<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-labelledby="modalEditarUsuarioLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="formEditarUsuario">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarUsuarioLabel">Editar Usuario</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body row g-3">
                    <div id="alerts-container2" class="mt-2"></div>
                    <input type="hidden" name="usuario_id" id="edit_id">

                    <div class="col-md-6">
                        <label for="edit_nombre" class="form-label">Nombre completo</label>
                        <input type="text" class="form-control" name="nombreedit" id="edit_nombre" required>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_rfc" class="form-label">RFC</label>
                        <input type="text" class="form-control" name="rfcedit" id="edit_rfc" required>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_curp" class="form-label">CURP</label>
                        <input type="text" class="form-control" name="curp" id="edit_curp" required>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_email" class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" id="edit_email" required>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_estado" class="form-label">Estado</label>
                        <select class="form-select" id="edit_estado" name="estado" required>
                            <option value="" selected disabled>Seleccione un estado</option>
                            <option value="AGS">Aguascalientes</option>
                            <option value="BC">Baja California</option>
                            <option value="BCS">Baja California Sur</option>
                            <option value="CAMP">Campeche</option>
                            <option value="CHIS">Chiapas</option>
                            <option value="CHIH">Chihuahua</option>
                            <option value="COAH">Coahuila</option>
                            <option value="COL">Colima</option>
                            <option value="CDMX">Ciudad de México</option>
                            <option value="DGO">Durango</option>
                            <option value="GTO">Guanajuato</option>
                            <option value="GRO">Guerrero</option>
                            <option value="HGO">Hidalgo</option>
                            <option value="JAL">Jalisco</option>
                            <option value="EDOMEX">Estado de México</option>
                            <option value="MICH">Michoacán</option>
                            <option value="MOR">Morelos</option>
                            <option value="NAY">Nayarit</option>
                            <option value="N.L">Nuevo León</option>
                            <option value="OAX">Oaxaca</option>
                            <option value="PUE">Puebla</option>
                            <option value="QRO">Querétaro</option>
                            <option value="QROO">Quintana Roo</option>
                            <option value="SLP">San Luis Potosí</option>
                            <option value="SIN">Sinaloa</option>
                            <option value="SON">Sonoma</option>
                            <option value="TAB">Tabasco</option>
                            <option value="TAMPS">Tamaulipas</option>
                            <option value="TLAX">Tlaxcala</option>
                            <option value="VER">Veracruz</option>
                            <option value="YUC">Yucatán</option>
                            <option value="ZAC">Zacatecas</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_estatus" class="form-label">Estatus</label>
                        <select class="form-select" name="estatus" id="edit_estatus">
                            <option value="INACTIVO">Inactivo</option>
                            <option value="ACTIVO">Activo</option>

                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_fecha_ingreso" class="form-label">Fecha de ingreso</label>
                        <input type="date" class="form-control" name="fecha_ingreso" id="edit_fecha_ingreso">
                    </div>

                    <!-- Promotoria (Búsqueda) -->
                    <div class="mb-3 search-dropdown position-relative">
                        <label for="searchPromotoria" class="form-label fw-semibold">
                            <i class="fas fa-users me-2"></i>Promotoría Actual:
                        </label>
                        <label for="searchPromotoria" id="namepromotoriaedit" class="form-label fw-semibold">

                        </label>
                        <div class="input-group mb-3">
                            <span class="input-group-text bg-primary text-white"><i class="fas fa-search"></i></span>
                            <input type="text" id="searchPromotoria" class="form-control search-input"
                                placeholder="Actualizar promotoria..."
                                data-url="../../../../controllers/searchPromotoriasController.php"
                                data-hidden="promotoriaID2" autocomplete="off">
                        </div>
                        <input type="hidden" id="promotoriaID2" name="promotoriaID2">
                        <div class="list-group mt-2 shadow-sm result-container"
                            style="max-height: 200px; overflow-y: auto; display: none;"></div>


                        <div class="error-message" id="promotoria-error">Seleccione una promotoría válida</div>
                    </div>

                    <!-- Puesto (Búsqueda) -->
                    <div class="mb-3 search-dropdown">
                        <label for="searchPuesto" class="form-label fw-semibold">
                            <i class="fas fa-briefcase me-2"></i>Puesto Actual:
                        </label>
                        <label for="searchPromotoria" id="namepuestoedit" class="form-label fw-semibold">

                        </label>
                        <div class="input-group mb-3">
                            <span class="input-group-text bg-primary text-white"><i class="fas fa-search"></i></span>
                            <input type="text" id="searchPuesto" class="form-control search-input"
                                placeholder="Buscar puesto..."
                                data-url="../../../../controllers/searchPuestosController.php" data-hidden="puestoID2"
                                autocomplete="off">
                        </div>
                        <input type="hidden" id="puestoID2" name="puestoID2">
                        <div class="list-group mt-2 shadow-sm result-container"
                            style="max-height: 200px; overflow-y: auto; display: none;"></div>

                        <div class="error-message" id="puesto-error">Seleccione un puesto válido</div>
                    </div>

                    <!-- Input de Rol corregido -->
                    <div class="mb-3 search-dropdown">
                        <label for="searchRol" class="form-label fw-semibold">
                            <i class="fas fa-user-tag me-2"></i>Rol Actual:
                        </label>
                        <label for="searchPromotoria" id="nameroledit" class="form-label fw-semibold">

                        </label>
                        <div class="input-group mb-3">
                            <span class="input-group-text bg-primary text-white"><i class="fas fa-search"></i></span>
                            <input type="text" id="searchRol" class="form-control search-input"
                                placeholder="Buscar rol..." data-url="../../../../controllers/searchRolesController.php"
                                data-hidden="rolID2" autocomplete="off">
                        </div>
                        <input type="hidden" id="rolID2" name="rolID2">
                        <div class="list-group mt-2 shadow-sm result-container"
                            style="max-height: 200px; overflow-y: auto; display: none;"></div>
                        <div class="error-message" id="rol-error">Seleccione un rol válido</div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" id="btnActualizarUsuario" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Actualizar Usuario
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    /*************************************SEARCH DE PROMOTORIAS, PUESTOS Y ROLOES */




    $(document).ready(function() {
        // Debounce para búsqueda en tiempo real
        let searchTimer;
        let allResults = {}; // Almacenará todos los resultados por campo

        $('.search-input').each(function() {
            const $input = $(this);
            const $searchContainer = $input.closest('.search-dropdown');
            const resultBox = $searchContainer.find('.result-container');
            const hiddenInput = $('#' + $input.data('hidden'));
            const url = $input.data('url');
            const fieldName = $input.attr('id').replace('search', '').toLowerCase();

            // Cargar todas las opciones al enfocar
            $input.on('focus', function() {
                if (!allResults[fieldName]) {
                    fetchAllOptions();
                } else {
                    showResults(allResults[fieldName]);
                }
            });

            // Función para cargar todas las opciones
            function fetchAllOptions() {
                $.ajax({
                    url: url,
                    method: 'GET',
                    data: {
                        q: ''
                    }, // Cadena vacía para obtener todos
                    dataType: 'json',
                    beforeSend: function() {
                        resultBox.html(
                            '<div class="loading-item"><i class="fas fa-spinner fa-spin me-2"></i>Cargando opciones...</div>'
                        ).show();
                    },
                    success: function(data) {
                        console.log('Todos los datos recibidos:', data);
                        allResults[fieldName] = data;
                        showResults(data);
                    },
                    error: function() {
                        resultBox.html(
                            '<div class="error-item"><i class="fas fa-exclamation-circle me-2"></i>Error al cargar datos</div>'
                        ).show();
                    }
                });
            }

            // Función para mostrar resultados
            function showResults(data) {
                let html = '';

                if (data && data.length > 0) {
                    data.forEach((item, index) => {
                        // Alternar fondo para mejor legibilidad
                        const bgClass = index % 2 === 0 ? '' : 'bg-light';
                        html += `
            <a href="#" class="result-item ${bgClass}" 
               data-id="${item.id}" data-name="${item.nombre}">
               <i class="fas fa-check-circle me-2 text-muted"></i>
               ${item.nombre}
            </a>`;
                    });
                } else {
                    html = '<div class="no-results-item">No se encontraron resultados</div>';
                }

                resultBox.html(html).stop(true, true).fadeIn(200);
            }


            // Búsqueda en tiempo real al escribir
            $input.on('input', function() {
                const query = $(this).val().trim().toLowerCase();
                clearTimeout(searchTimer);

                if (!allResults[fieldName]) return;

                searchTimer = setTimeout(() => {
                    if (query === '') {
                        showResults(allResults[fieldName]);
                    } else {
                        const filtered = allResults[fieldName].filter(item =>
                            item.nombre.toLowerCase().includes(query)
                        );
                        showResults(filtered);
                    }
                }, 200);
            });

            // Selección de un resultado
            resultBox.on('click', '.result-item', function(e) {
                e.preventDefault();
                const id = $(this).data('id');
                const name = $(this).data('name');

                $input.val(name);
                hiddenInput.val(id);
                resultBox.hide();
                console.log(id + ' ' + name);
                // Limpiar errores
                $searchContainer.find('.error-message').hide();
                $input.removeClass('is-invalid');
            });

            // Ocultar resultados al hacer clic fuera
            $(document).on('click', function(e) {
                if (!$(e.target).closest($searchContainer).length) {
                    resultBox.hide();
                }
            });
        });
    });





    /****************************************DATATABLE */
    $(document).ready(function() {
        if ($.fn.DataTable.isDataTable('#dataTableEmpleados')) {
            $('#dataTableEmpleados').DataTable().clear().destroy();
        }

        $('#dataTableEmpleados').DataTable({
            "processing": true,
            "serverSide": true,

            "ajax": {
                "url": "../../../../controllers/obtenerEmpleadosController.php",
                "type": "GET",
                "dataSrc": function(json) {
                    if (json.error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error al cargar los datos',
                            text: json.error
                        });
                        return [];
                    }
                    //console.log(json.data);
                    return json.data;
                }
            },
            "columns": [{
                    "data": "usuario_id"
                },
                {
                    "data": "nombre_completo",
                    "render": function(data, type, row) {
                        return `<span class="fw-semibold">${data}</span>`;
                    }
                },
                {
                    "data": "rfc",
                    "render": function(data, type, row) {
                        return data ?
                            `<span class="text-muted">${data.substring(0, 40)}${data.length > 40 ? '...' : ''}</span>` :
                            '-';
                    }
                },
                {
                    "data": "curp"

                },
                {
                    "data": "email"
                },
                {
                    "data": "estado_lugar"
                },
                {
                    "data": "nombre_promotoria"
                },
                {
                    "data": "nombre_puesto"
                },
                {
                    "data": "nombre_rol"
                },
                {
                    "data": "status",
                    "className": "text-center",
                    "render": function(data) {
                        const badgeClass = data === 'ACTIVO' ? 'bg-success' :
                            data === 'INACTIVO' ? 'bg-secondary' :
                            data === 'En progreso' ? 'bg-warning text-dark' : 'bg-info';
                        return `<span class="badge badge-status ${badgeClass}">${data}</span>`;
                    }
                },
                {
                    "data": "fecha_ingreso"
                },
                {
                    "data": "created_at"
                },
                {
                    "data": "updated_at"
                },

                {
                    "data": null,
                    "className": "text-center action-btns",
                    "orderable": false,
                    "render": function(data, type, row) {
                        return `
                        <div class="d-flex justify-content-center">
                            <button class="btn btn-sm btn-outline-primary btnEditar" data-id="${row.usuario_id}" 
                            data-nombre="${row.nombre_completo}"
                            data-rfc="${row.rfc}"
                            data-curp="${row.curp}"
                            data-email="${row.email}"
                            data-estadolugar="${row.estado_lugar}"
                            data-idpromotoria="${row.promotoria_id}"
                            data-nompromotoria="${row.nombre_promotoria}"
                            data-idpuesto="${row.puesto_id}"
                            data-nompuesto="${row.nombre_puesto}"
                            data-idrol="${row.rol_id}"
                            data-nomrol="${row.nombre_rol}"
                            data-status="${row.status}"
                            data-dateingreso="${row.fecha_ingreso}"
                             data-bs-toggle="modal" data-bs-target="#modalEditarUsuario"
                            title="Editar">
                                <i class="bi bi-pencil"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger btnEliminar" data-id="${row.usuario_id}" title="Eliminar">
                                <i class="bi bi-trash"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-success btnDetalles" data-id="${row.usuario_id}" title="Ver detalles">
                                <i class="bi bi-eye"></i>
                            </button>
                        </div>
                        `;
                    }
                }
            ],
            "language": {
                "sProcessing": "<div class='spinner-border text-primary' role='status'><span class='visually-hidden'>Cargando...</span></div>",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sEmptyTable": "No hay datos disponibles",
                "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
                "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
                "sInfoFiltered": "(filtrado de _MAX_ registros)",
                "sSearch": "<i class='bi bi-search me-1'></i>",
                "oPaginate": {
                    "sFirst": "<i class='bi bi-chevron-double-left'></i>",
                    "sPrevious": "<i class='bi bi-chevron-left'></i>",
                    "sNext": "<i class='bi bi-chevron-right'></i>",
                    "sLast": "<i class='bi bi-chevron-double-right'></i>"
                }
            },
            "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "paging": true,
            "responsive": true,
            "pageLength": 10,
            "lengthChange": true,
            "info": true,
            "autoWidth": false,
            "drawCallback": function(settings) {
                // Tooltips para botones
                $('[title]').tooltip({
                    trigger: 'hover',
                    placement: 'top'
                });
            },
            "initComplete": function() {
                // Personalización de inputs
                $('.dataTables_filter input').attr('placeholder', 'Buscar...');
                $('.dataTables_filter label').contents().filter(function() {
                    return this.nodeType === 3;
                }).remove();
            }
        });

        // Evento para editar
        $('#dataTableEmpleados tbody').on('click', '.btnEditar', function() {
            const id = $(this).data('id');
            const nombre = $(this).data('nombre');
            const rfc = $(this).data('rfc');
            const curp = $(this).data('curp');
            const email = $(this).data('email');
            const estadolugar = $(this).data('estadolugar');
            const nompromotoria = $(this).data('nompromotoria');
            const nompuesto = $(this).data('nompuesto');
            const nomrol = $(this).data('nomrol');
            const status = $(this).data('status');
            const dateingreso = $(this).data('dateingreso');
            const idpromotoria = $(this).data('idpromotoria');
            const idpuesto = $(this).data('idpuesto');
            const idrol = $(this).data('idrol');
            $('#edit_id').val(id);
            $('#edit_nombre').val(nombre);
            $('#edit_rfc').val(rfc);
            $('#edit_curp').val(curp);
            $('#edit_email').val(email);
            $('#edit_estado').val(estadolugar);
            $('#edit_estatus').val(status);
            $('#edit_fecha_ingreso').val(dateingreso);
            $('#namepromotoriaedit').text(nompromotoria);
            $('#namepuestoedit').text(nompuesto);
            $('#nameroledit').text(nomrol);

        });

        $('#formEditarUsuario').on('submit', function(e) {
            e.preventDefault();
            const $btn = $('#btnActualizarUsuario');
            const formData = new FormData(this);

            $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i> Actualizando...');

            $.ajax({
                url: '../../../../controllers/updateUsusariosController.php',
                method: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(res) {
                    if (res.success) {
                        mostrarAlerta('success', res.message ||
                            'Usuario actualizado correctamente');
                        //$('#modalEditarUsuario').modal('hide');
                        $('#dataTableEmpleados').DataTable().ajax.reload(); // Refrescar tabla
                    } else {
                        mostrarAlerta('error', res.message || 'Ocurrió un error al actualizar');
                    }
                },
                error: function(xhr) {
                    let msg = 'Error al conectar con el servidor';
                    try {
                        const res = xhr.responseJSON || JSON.parse(xhr.responseText);
                        msg = res.message || msg;
                    } catch (_) {}
                    mostrarAlerta('error', msg);
                },
                complete: function() {
                    $btn.prop('disabled', false).html(
                        '<i class="fas fa-save me-1"></i> Actualizar Usuario');
                }
            });
        });

        $('#modalEditarUsuario, #crearUsuarioModal').on('hidden.bs.modal', function() {
            $(this).find('.alert').hide();
        });



        // Evento para eliminar
        $('#dataTableEmpleados tbody').on('click', '.btnEliminar', function() {
            const id = $(this).data('id');
            Swal.fire({
                title: '¿Eliminar usuario?',
                text: "Esta acción no se puede deshacer",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar',
                backdrop: 'rgba(0,0,0,0.4)',
                customClass: {
                    confirmButton: 'btn btn-danger me-2',
                    cancelButton: 'btn btn-secondary'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    // Simular eliminación
                    Swal.fire({
                        title: 'Eliminado',
                        text: 'El curso ha sido eliminado',
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    });
                    // En producción, aquí iría tu llamada AJAX
                    // table.ajax.reload();
                }
            });
        });
    });

    /***************************************************VALIDACION/ENVIO DE DATOS USUARIOS */

    document.getElementById('togglePassword').addEventListener('click', function() {
        const passwordInput = document.getElementById('password');
        const icon = this.querySelector('i');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });


    // Validación de RFC para México
    function validarRFC(rfc) {
        const regex = /^[A-ZÑ&]{3,4}\d{6}[A-V1-9][A-Z1-9][0-9A]$/;
        return regex.test(rfc);
    }

    // Validación de CURP para México
    function validarCURP(curp) {
        const regex =
            /^[A-Z][AEIOUX][A-Z]{2}\d{2}(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1])[HM](AS|BC|BS|CC|CS|CH|CL|CM|DF|DG|GT|GR|HG|JC|MC|MN|MS|NT|NL|OC|PL|QT|QR|SP|SL|SR|TC|TS|TL|VZ|YN|ZS|NE)[B-DF-HJ-NP-TV-Z]{3}[0-9A-Z]\d$/;
        return regex.test(curp);
    }

    // Validación de email
    function validarEmail(email) {
        const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return regex.test(email);
    }

    // Validación del formulario



    // 1. Configuración inicial
    document.addEventListener('DOMContentLoaded', function() {
        // 2. Manejador del evento click mejorado
        document.getElementById('btnGuardarUsuario').addEventListener('click', function(e) {
            e.preventDefault(); // Previene el comportamiento por defecto
            if (!validarFormulario()) return;
            enviarFormulario();
        });
    });

    // 3. Función de validación mejorada
    function validarFormulario() {
        let isValid = true;
        const form = document.getElementById('formCrearUsuario');

        // Función auxiliar para validación
        function validarCampo(campoId, validatorFn, errorId) {
            const campo = document.getElementById(campoId);
            const errorElement = document.getElementById(errorId);

            if (!validatorFn(campo.value)) {
                errorElement.style.display = 'block';
                campo.classList.add('is-invalid');
                isValid = false;

                // Scroll al primer error encontrado
                if (isValid === false) {
                    isValid = null; // Marcar que ya encontramos el primer error
                    campo.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            } else {
                errorElement.style.display = 'none';
                campo.classList.remove('is-invalid');
            }
        }

        // Validación de campos
        validarCampo('password', val => /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[-_@$!%*?&])[A-Za-z\d\-_@$!%*?&]{8,}$/.test(
            val), 'password-error');
        validarCampo('nombre', val => val.trim() !== '', 'nombre-error');
        validarCampo('rfc', val => validarRFC(val.toUpperCase()), 'rfc-error');
        validarCampo('curp', val => validarCURP(val.toUpperCase()), 'curp-error');
        validarCampo('email', validarEmail, 'email-error');
        validarCampo('estado', val => val !== null && val !== '', 'estado-error');
        validarCampo('searchPromotoria', val => val.trim() !== '', 'promotoria-error');
        validarCampo('searchPuesto', val => val.trim() !== '', 'puesto-error');
        validarCampo('searchRol', val => val.trim() !== '', 'rol-error');
        validarCampo('estatus', val => val !== null && val !== '', 'estatus-error');
        validarCampo('fecha_ingreso', val => val !== '', 'fecha_ingreso-error');

        return isValid;
    }

    // 4. Función de envío mejorada
    function enviarFormulario() {
        const $form = $('#formCrearUsuario');
        const $btn = $('#btnGuardarUsuario');

        // Bloquear doble envío
        if ($btn.prop('disabled')) return;
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i> Guardando...');

        // Crear FormData y verificar contenido
        const formData = new FormData($form[0]);
        console.log('Datos a enviar:', Object.fromEntries(formData.entries()));

        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                console.log('Respuesta del servidor:', response);

                if (response && response.success) {
                    // mostrarAlerta('success', response.message || 'Usuario creado correctamente');
                    resetFormulario();
                    $('#dataTableEmpleados').DataTable().ajax.reload();

                    // Cerrar modal si está en uno

                    // if (modal.length) modal.modal('hide');



                    mostrarAlerta('success', response.message || 'Usuario creado correctamente');
                    // setTimeout(() => {
                    //     if (modal.length) modal.modal('hide');

                    // }, 1500);



                } else {
                    const errorMsg = response && response.message ? response.message :
                        'Error desconocido del servidor';
                    mostrarAlerta('error', errorMsg);
                }
            },
            error: function(xhr) {
                console.error('Error en la petición:', xhr);
                let errorMsg = 'Error al conectar con el servidor';

                try {
                    const response = xhr.responseJSON || JSON.parse(xhr.responseText);
                    errorMsg = response.message || errorMsg;
                } catch (e) {
                    errorMsg = xhr.statusText || errorMsg;
                }

                mostrarAlerta('error', errorMsg);
            },
            complete: function() {
                $btn.prop('disabled', false).html('<i class="fas fa-save me-1"></i> Guardar Usuario');
            }
        });
    }

    // 5. Funciones auxiliares (mantener tus versiones actuales)
    function mostrarAlerta(type, message) {
        const tipoBootstrap = (type === 'error') ? 'danger' : type;

        const alertHtml = `
        <div class="alert alert-${tipoBootstrap} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    `;

        $('#alerts-container').html(alertHtml);
        $('#alerts-container2').html(alertHtml);
    }


    function resetFormulario() {
        $('#formCrearUsuario')[0].reset();
        $('.search-input').val('');
        $('[id$="ID"]').val(''); // Limpiar todos los campos hidden que terminan con "ID"
        $('.result-container').hide();
        $('.error-message').hide();
        $('.is-invalid').removeClass('is-invalid');
    }

    // Funciones de validación específicas
    function validarRFC(rfc) {
        return /^[A-ZÑ&]{3,4}\d{6}[A-Z0-9]{3}$/.test(rfc);
    }

    function validarCURP(curp) {
        return /^[A-Z]{4}\d{6}[HM][A-Z]{5}[A-Z0-9]\d$/.test(curp);
    }

    function validarEmail(email) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
    }
</script>
<?php require('../../components/FooterAdmin.php'); ?>