<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php'); ?>
<style>
.card .custom-card {
    border-radius: 0.25rem;
    background-color: var(--custom-white);
    box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
    border: 0;
    position: relative;
    margin-block-end: 1.5rem;
    width: 100%;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;

}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}

/* Estilos para los encabezados de tabla mejorados */
.header-gradient {

    color: black !important;
    text-transform: uppercase;
    font-weight: 600;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 15px 10px !important;
    position: relative;
    border: none !important;
    text-shadow: 0 1px 1px rgba(0, 0, 0, 0.2);
    transition: all 0.3s ease;
}

.header-gradient:hover {

    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.header-gradient::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 80%;
    height: 2px;
    background: rgba(255, 255, 255, 0.3);
}

/* Efecto para ordenación (si usas sorting) */
.header-gradient.sorting:after,
.header-gradient.sorting_asc:after,
.header-gradient.sorting_desc:after {
    content: '↑↓';
    font-family: 'Arial', sans-serif;
    position: absolute;
    right: 8px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 0.9rem;
}

.header-gradient.sorting_asc:after {
    content: '↑';
    color: white;
}

.header-gradient.sorting_desc:after {
    content: '↓';
    color: white;
}

/* Ajuste para columnas específicas */
th.header-gradient:first-child {
    border-radius: 10px 0 0 10px !important;
}

th.header-gradient:last-child {
    border-radius: 0 10px 10px 0 !important;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card shadow-header">
                    <div class="card-header">
                        <h3 class="card-title">Cursos.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#nuevoCursoModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Crear Nuevo Curso
                        </button>
                        <table id="dataTableCursos" class="table table-hover table-borderless mb-0">
                            <thead>
                                <tr>
                                    <th class="text-center header-gradient">ID</th>
                                    <th class="header-gradient" width="15%">Nombre Curso</th>
                                    <th class="header-gradient" width="25%">Descripción</th>
                                    <th class="header-gradient">Fecha Inicio</th>
                                    <th class="header-gradient">Fecha Fin</th>
                                    <th class="text-center header-gradient">Estado</th>
                                    <th class="header-gradient">Categoria</th>
                                    <th class="header-gradient">Fecha Creado</th>
                                    <th class="header-gradient">Fecha Actualizacion</th>
                                    <th class="header-gradient">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->

<!-- 
<div class="modal fade" id="nuevoCursoModal" tabindex="-1" aria-labelledby="nuevoCursoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white fw-bold" id="nuevoCursoModalLabel">Ingresar Curso</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formnuevocurso">
                    <div class="row">
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="nombre">Seleccione Categoria</label>
                                <input type="text" id="searchInput" class="form-control mb-3" placeholder="Buscar..."
                                    autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false"
                                    style="width: 100%;">
                                <input type="hidden" id="searchInputID" name="searchInputID">
                                <div id="results" style="max-height: 200px; overflow-y: auto;"></div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <label for="nombrenuevotext" class="form-label fw-bold">Nombre Del Curso:</label>
                            <textarea name="nombrenuevotext" id="nombrenuevotext" class="form-control" rows="4"
                                style="border-radius: 5px; padding: 10px; resize: none;"></textarea>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="fechaInput" class="form-label">Fecha Inicio</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-calendar"></i></span>
                                    <input type="date" class="form-control" id="fechainicio" name="fechainicio">
                                </div>
                                <div class="form-text">Selecciona la fecha inicio</div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="fechaInput" class="form-label">Fecha Fin</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-calendar"></i></span>
                                    <input type="date" class="form-control" id="fechafin" name="fechafin">
                                </div>
                                <div class="form-text">Selecciona la fecha fin</div>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12 col-sm-3 mb-3">
                            <div class="mb-3">
                                <label for="estadoSelect" class="form-label">Estado</label>
                                <select class="form-select" id="estadocurso" name="estadocurso">
                                    <option value="ACTIVO">ACTIVO</option>
                                    <option value="INACTIVO">INACTIVO</option>
                                </select>
                                <div class="form-text">Indica si el elemento está activo o inactivo.</div>
                            </div>

                        </div>

                        <div id="editor" style="height: 300px;">
                            <p>Escribe los objetivos del curso...</p>
                        </div>
                        <textarea class="hidden" name="contentarea" id="contentarea"></textarea>

                    </div>

                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="submit" id="guardarnuevocurso" class="btn btn-primary">Guardar Datos</button>
            </div>

        </div>
    </div>
</div> -->


<div class="modal fade" id="nuevoCursoModal" tabindex="-1" aria-labelledby="nuevoCursoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow">
            <!-- Encabezado con estilo educativo -->
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <i class="fas fa-graduation-cap me-3 fs-4"></i>
                    <h5 class="modal-title fw-bold mb-0" id="nuevoCursoModalLabel">Crear Nuevo Curso</h5>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-4">
                <form id="formnuevocurso">
                    <!-- Sección 1: Información Básica -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-info-circle me-2"></i>Información Principal
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Categoría -->
                                <div class="col-md-3">
                                    <label for="searchInput" class="form-label fw-semibold">
                                        <i class="fas fa-tag me-2"></i>Categoría del Curso
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-search"></i>
                                        </span>
                                        <input type="text" id="searchInput" class="form-control"
                                            placeholder="Buscar categoría..." autocomplete="off" autocorrect="off"
                                            autocapitalize="off" spellcheck="false">
                                    </div>
                                    <input type="hidden" id="searchInputID" name="searchInputID">
                                    <div id="results" class="list-group mt-2 shadow-sm"
                                        style="max-height: 200px; overflow-y: auto;">
                                        <div class="list-group-item list-group-item-action">Ejemplo de resultado</div>
                                    </div>
                                </div>

                                <!-- Nombre del Curso -->
                                <div class="col-md-3">
                                    <label for="nombrenuevotext" class="form-label fw-semibold">
                                        <i class="fas fa-heading me-2"></i>Nombre del Curso
                                    </label>
                                    <textarea name="nombrenuevotext" id="nombrenuevotext" class="form-control" rows="4"
                                        style="border-radius: 5px; padding: 10px; resize: none;"
                                        placeholder="Ej: Introducción a la Programación Web"></textarea>
                                </div>

                                <!-- Fechas -->
                                <div class="col-md-3">
                                    <label for="fechainicio" class="form-label fw-semibold">
                                        <i class="fas fa-calendar-day me-2"></i>Fecha de Inicio
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-calendar-alt"></i>
                                        </span>
                                        <input type="date" class="form-control" id="fechainicio" name="fechainicio">
                                    </div>
                                    <small class="text-muted">Cuando comienza el curso</small>
                                </div>

                                <div class="col-md-3">
                                    <label for="fechafin" class="form-label fw-semibold">
                                        <i class="fas fa-calendar-times me-2"></i>Fecha de Finalización
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-calendar-alt"></i>
                                        </span>
                                        <input type="date" class="form-control" id="fechafin" name="fechafin">
                                    </div>
                                    <small class="text-muted">Cuando finaliza el curso</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 2: Configuración -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-cog me-2"></i>Configuración del Curso
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="estadocurso" class="form-label fw-semibold">
                                        <i class="fas fa-power-off me-2"></i>Estado del Curso
                                    </label>
                                    <select class="form-select" id="estadocurso" name="estadocurso">
                                        <option value="ACTIVO" class="text-success">ACTIVO</option>
                                        <option value="INACTIVO" class="text-secondary">INACTIVO</option>
                                    </select>
                                    <small class="text-muted">Disponibilidad del curso</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sección 3: Objetivos -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-bullseye me-2"></i>Objetivos del Curso
                        </div>
                        <div class="card-body">
                            <div id="editor"
                                style="height: 250px; border-radius: 5px; border: 1px solid #dee2e6; padding: 10px;">
                                <p>Describe los objetivos y metas de aprendizaje de este curso...</p>
                            </div>
                            <textarea class="d-none" name="contentarea" id="contentarea"></textarea>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Pie de modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Cancelar
                </button>
                <button type="submit" id="guardarnuevocurso" class="btn btn-primary">
                    <i class="fas fa-save me-1"></i> Guardar Curso
                </button>
            </div>
        </div>
    </div>
</div>





<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
//SCRIPT PARA LA BUSQUEDA DE USUARIOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../../controllers/searchCategoriasController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.categoria_id}" data-name="${item.titulo}">
                                <strong>${item.titulo}</strong><br>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});
$(document).ready(function() {
    if ($.fn.DataTable.isDataTable('#dataTableCursos')) {
        $('#dataTableCursos').DataTable().clear().destroy();
    }

    $('#dataTableCursos').DataTable({
        "processing": true,
        "serverSide": true,

        "ajax": {
            "url": "../../../../controllers/obtenerCursosController.php",
            "type": "GET",
            "dataSrc": function(json) {
                if (json.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al cargar los datos',
                        text: json.error
                    });
                    return [];
                }
                //console.log(json.data);
                return json.data;
            }
        },
        "columns": [{
                "data": "curso_id"
            },
            {
                "data": "curso_title",
                "render": function(data, type, row) {
                    return `<span class="fw-semibold">${data}</span>`;
                }
            },
            {
                "data": "curso_description",
                "render": function(data, type, row) {
                    return data ?
                        `<span class="text-muted">${data.substring(0, 40)}${data.length > 40 ? '...' : ''}</span>` :
                        '-';
                }
            },
            {
                "data": "fecha_inicio"

            },
            {
                "data": "fecha_fin"
            },
            {
                "data": "estado",
                "className": "text-center",
                "render": function(data) {
                    const badgeClass = data === 'ACTIVO' ? 'bg-success' :
                        data === 'INACTIVO' ? 'bg-secondary' :
                        data === 'En progreso' ? 'bg-warning text-dark' : 'bg-info';
                    return `<span class="badge badge-status ${badgeClass}">${data}</span>`;
                }
            },
            {
                "data": "categoria",
                "render": function(data) {
                    return data ?
                        `<span class="badge bg-primary bg-opacity-10 text-primary">${data}</span>` :
                        '-';
                }
            },
            {
                "data": "created_at"
            },
            {
                "data": "updated_at"
            },

            {
                "data": null,
                "className": "text-center action-btns",
                "orderable": false,
                "render": function(data, type, row) {
                    return `
                        <div class="d-flex justify-content-center">
                            <button class="btn btn-sm btn-outline-primary btnEditar" data-id="${row.curso_id}" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger btnEliminar" data-id="${row.curso_id}" title="Eliminar">
                                <i class="bi bi-trash"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-success btnDetalles" data-id="${row.curso_id}" title="Ver detalles">
                                <i class="bi bi-eye"></i>
                            </button>
                        </div>
                        `;
                }
            }
        ],
        "language": {
            "sProcessing": "<div class='spinner-border text-primary' role='status'><span class='visually-hidden'>Cargando...</span></div>",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "No hay datos disponibles",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sSearch": "<i class='bi bi-search me-1'></i>",
            "oPaginate": {
                "sFirst": "<i class='bi bi-chevron-double-left'></i>",
                "sPrevious": "<i class='bi bi-chevron-left'></i>",
                "sNext": "<i class='bi bi-chevron-right'></i>",
                "sLast": "<i class='bi bi-chevron-double-right'></i>"
            }
        },
        "dom": "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "paging": true,
        "responsive": true,
        "pageLength": 10,
        "lengthChange": true,
        "info": true,
        "autoWidth": false,
        "drawCallback": function(settings) {
            // Tooltips para botones
            $('[title]').tooltip({
                trigger: 'hover',
                placement: 'top'
            });
        },
        "initComplete": function() {
            // Personalización de inputs
            $('.dataTables_filter input').attr('placeholder', 'Buscar...');
            $('.dataTables_filter label').contents().filter(function() {
                return this.nodeType === 3;
            }).remove();
        }
    });

    // Evento para editar
    $('#dataTableCursos tbody').on('click', '.btnEditar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Editar Curso',
            text: `Editarás el curso con ID: ${id}`,
            icon: 'info',
            confirmButtonText: 'Continuar'
        });
    });

    // // Acciones con delegación de eventos
    // $('#dataTableDetallesCurso tbody').on('click', '.btnEditar', function() {
    //     const id = $(this).data('id');
    //     // Aquí puedes abrir un modal o redirigir
    //     console.log("Editar curso con ID:", id);
    //     Swal.fire("Editar", "Aquí abrirías el modal para editar ID " + id, "info");
    // });

    // $('#dataTableDetallesCurso tbody').on('click', '.btnEliminar', function() {
    //     const id = $(this).data('id');
    //     Swal.fire({
    //         title: '¿Estás seguro?',
    //         text: "Esta acción no se puede deshacer.",
    //         icon: 'warning',
    //         showCancelButton: true,
    //         confirmButtonText: 'Sí, eliminar',
    //         cancelButtonText: 'Cancelar'
    //     }).then((result) => {
    //         if (result.isConfirmed) {
    //             $.ajax({
    //                 url: '../../../controllers/eliminarDetalleCursoController.php',
    //                 type: 'POST',
    //                 data: {
    //                     id: id
    //                 },
    //                 success: function(response) {
    //                     const res = JSON.parse(response);
    //                     if (res.success) {
    //                         Swal.fire('Eliminado', res.message, 'success');
    //                         $('#dataTableDetallesCurso').DataTable().ajax.reload(
    //                             null, false);
    //                     } else {
    //                         Swal.fire('Error', res.message, 'error');
    //                     }
    //                 },
    //                 error: function() {
    //                     Swal.fire('Error', 'No se pudo conectar con el servidor.',
    //                         'error');
    //                 }
    //             });
    //         }
    //     });
    // });

    // Evento para editar
    $('#dataTableCursos tbody').on('click', '.btnEditar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Editar Curso',
            text: `Editarás el curso con ID: ${id}`,
            icon: 'info',
            confirmButtonText: 'Continuar'
        });
    });
    // Evento para eliminar
    $('#dataTableCursos tbody').on('click', '.btnEliminar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: '¿Eliminar curso?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            backdrop: 'rgba(0,0,0,0.4)',
            customClass: {
                confirmButton: 'btn btn-danger me-2',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // Simular eliminación
                Swal.fire({
                    title: 'Eliminado',
                    text: 'El curso ha sido eliminado',
                    icon: 'success',
                    timer: 1500,
                    showConfirmButton: false
                });
                // En producción, aquí iría tu llamada AJAX
                // table.ajax.reload();
            }
        });
    });
});

$(document).ready(function() {

    var quill = new Quill('#editor', {
        theme: 'snow', // Tema "snow" para una interfaz limpia
        modules: {
            toolbar: [
                ['bold', 'italic', 'underline', 'strike'], // Formato básico
                ['blockquote', 'code-block'], // Bloques
                [{
                    'header': [1, 2, 3, false]
                }], // Encabezados
                [{
                    'list': 'ordered'
                }, {
                    'list': 'bullet'
                }], // Listas
                [{
                    'indent': '-1'
                }, {
                    'indent': '+1'
                }], // Indentación
                [{
                    'align': []
                }], // Alineación
                ['link'] // Enlaces
            ]
        }
    });
    quill.on('text-change', function() {
        document.querySelector('#contentarea').value = quill.root.innerHTML;
    })

    $('#guardarnuevocurso').click(function() {
        // Validar el formulario
        if ($('#formnuevocurso')[0].checkValidity()) {


            const formData = {
                id_categoria: $('#searchInputID').val(),
                nuevocurso: $('#nombrenuevotext').val(),
                fechainicio: $('#fechainicio').val(),
                fechafin: $('#fechafin').val(),
                estadocurso: $('#estadocurso').val(),
                objetivos: $('#contentarea').val(),
            };

            // Enviar datos con AJAX
            $.ajax({
                url: '../../../../controllers/registroCursoController.php',
                type: 'POST',
                data: formData,
                success: function(response) {
                    const result = JSON.parse(response);
                    if (result.status === "success") {
                        Swal.fire({
                            icon: 'success',
                            title: 'Éxito',
                            text: result.message,
                        }).then(() => {
                            $('#formdetallescurso').modal('hide');
                            location.reload();
                        });

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: result.message,
                        });
                    }
                },
                error: function(xhr, status, error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error de conexión',
                        text: 'No se pudo conectar al servidor. Inténtelo de nuevo más tarde.',
                    });
                },
            });
        } else {
            // Mostrar errores de validación
            $('#formdetallescurso')[0].reportValidity();
        }
    });
});
</script>


<?php require('../../components/FooterAdmin.php'); ?>