<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php');
?>

<style>
.card .custom-card {
    border-radius: 0.25rem;
    background-color: var(--custom-white);
    box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
    border: 0;
    position: relative;
    margin-block-end: 1.5rem;
    width: 100%;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item-2 {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item-2:hover {
    background-color: #e9ecef;
}

#results2 {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>

<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detalles Curso</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#titulosCursoModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Añadir Titulos a Curso
                        </button>
                        <table id="dataTableTItulos" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nombre Curso</th>

                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->




<div class="modal fade" id="titulosCursoModal" tabindex="-1" aria-labelledby="titulosCursoModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con estilo educativo -->
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <i class="fas fa-info-circle me-3 fs-4"></i>
                    <h5 class="modal-title fw-bold mb-0" id="titulosCursoModalLabel">Titulos del Curso</h5>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-4">
                <form id="formaddtitulos">
                    <!-- Sección 1: Información Básica -->
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-search me-2"></i>Ingreso De Titulos a Curso
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Búsqueda de curso -->
                                <div class="col-md-4">
                                    <label for="searchInput" class="form-label fw-semibold">
                                        <i class="fas fa-book me-2"></i>Buscar Curso
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-search"></i>
                                        </span>
                                        <input type="text" id="searchInput" class="form-control"
                                            placeholder="Escribe para buscar..." autocomplete="off" autocorrect="off"
                                            autocapitalize="off" spellcheck="false">
                                    </div>
                                    <input type="hidden" id="searchInputID" name="searchInputID">
                                    <div id="results" class="list-group mt-2 shadow-sm"
                                        style="max-height: 200px; overflow-y: auto;"></div>
                                </div>
                                <!-- título -->
                                <div class="col-md-4">
                                    <label for="nombrecontenidotext" class="form-label fw-semibold">
                                        <i class="fas fa-heading me-2"></i>Título/Nombre
                                    </label>
                                    <textarea name="nombreTitulostext" id="nombreTitulostext" class="form-control"
                                        rows="4" style="resize: none;"
                                        placeholder="Ej: Introducción a la promotoria..."></textarea>
                                </div>
                                <!-- Descripcion -->
                                <div class="col-md-4">
                                    <label for="nombrecontenidotext" class="form-label fw-semibold">
                                        <i class="fas fa-heading me-2"></i>Descripción
                                    </label>
                                    <textarea name="descripciontext" id="descripciontext" class="form-control" rows="4"
                                        style="resize: none;" placeholder="Descripción..."></textarea>
                                </div>

                                <!-- Nivel -->
                                <div class="col-md-4">
                                    <label for="nivelSubtema" class="form-label fw-semibold">
                                        <i class="fas fa-layer-group me-2"></i>Nivel del Contenido
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-sort-numeric-up"></i>
                                        </span>
                                        <input type="number" name="orden" id="nivelSubtema" class="form-control" min="1"
                                            max="10" value="1" placeholder="1-10">
                                    </div>
                                    <small class="text-muted">Indica la prioridad/orden de este contenido</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-4 border-primary">
                        <div class="card-header bg-light-primary text-primary fw-bold">
                            <i class="fas fa-search me-2"></i>Relacione el Titulo con Cuestionario
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Búsqueda de Cuestionario -->
                                <div class="col-md-4">
                                    <label for="searchInput" class="form-label fw-semibold">
                                        <i class="fas fa-book me-2"></i>Buscar Cuestionario
                                    </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-primary text-white">
                                            <i class="fas fa-search"></i>
                                        </span>
                                        <input type="text" id="searchInput2" class="form-control"
                                            placeholder="Buscar Cuestionario..." autocomplete="off" autocorrect="off"
                                            autocapitalize="off" spellcheck="false">
                                    </div>
                                    <input type="hidden" id="searchInputID2" name="searchInputID2">
                                    <div id="results2" class="list-group mt-2 shadow-sm"
                                        style="max-height: 200px; overflow-y: auto;"></div>
                                    <small class="text-muted">Seleccione a que Cuestionario Pertenece este
                                        titulo</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="w-100">
                            <button type="submit" class="btn btn-primary w-100 py-2 fw-bold">
                                <i class="fas fa-save me-2"></i>Guardar Contenido
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Pie de modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Cancelar
                </button>
            </div>
        </div>
    </div>
</div>


<script>
//SCRIPT PARA LA BUSQUEDA DE CURSOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../../controllers/searchUsuariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.curso_id}" data-name="${item.curso_title}">
                                <strong>${item.curso_title}</strong><br>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });


    //********************************************************************* */ Evento de clic para mostrar resultados - Cuestionarios
    $('#searchInput2').on('focus', function() {
        $('#results2').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query2 = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query2 === '') {
            fetchResults2('');
        }
    });

    //******************************************** */ Evento de búsqueda en tiempo real
    $('#searchInput2').on('keyup', function() {
        const query2 = $(this).val();

        // Llamada AJAX al servidor
        fetchResults2(query2);
    });
    //****************************************************************************** */ Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults2(query2) {
        $.ajax({
            url: '../../../../controllers/searchCuestionariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q2: query2
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data2) {
                //console.log(data);
                let resultsHTML2 = '';

                if (data2.length > 0) {
                    data2.forEach(item2 => {
                        resultsHTML2 += `
                            <div class="result-item-2" data-idc="${item2.cuestionario_id}" data-namec="${item2.titulo}">
                                <strong>${item2.titulo}</strong><br>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML2 =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results2').html(resultsHTML2);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results2').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }
    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item-2", function() {
        const id2 = $(this).data("idc");
        const name2 = $(this).data("namec");
        const nombrecompleto2 = name2;
        $("#searchInput2").val(nombrecompleto2); // Poner el id en el input
        $("#searchInputID2").val(id2); // Poner el id en el input
        $("#results2").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput2, #results2').length) {
            $('#results2').fadeOut();
        }
    });
});


// $(document).ready(function() {
//     if ($.fn.DataTable.isDataTable('#dataTableTItulos')) {
//         $('#dataTableTItulos').DataTable().clear().destroy();
//     }

//     $('#dataTableTItulos').DataTable({
//         "processing": true,
//         "serverSide": true,

//         "ajax": {
//             "url": "../../../../controllers/obtenerTitutosCursos.php",
//             "type": "GET",
//             "dataSrc": function(json) {
//                 if (json.error) {
//                     Swal.fire({
//                         icon: 'error',
//                         title: 'Error al cargar los datos',
//                         text: json.error
//                     });
//                     return [];
//                 }
//                 //console.log(json.data);
//                 return json.data;
//             }
//         },
//         "columns": [{
//                 "data": "ID_Titulo"
//             },
//             {
//                 "data": "curso_title"
//             },
//             {
//                 "data": "nom_titulo_temario"
//             },
//             {
//                 "data": "descripcion_temario"
//             },
//             {
//                 "data": "orden"
//             },

//             {
//                 "data": null,
//                 "render": function(data, type, row) {
//                     return `
//                         <button class="btn btn-sm btn-warning me-1 btnEditar" data-id="${row.ID_Titulo}">
//                             <i class="bi bi-pencil"></i> Editar
//                         </button>
//                         <button class="btn btn-sm btn-danger btnEliminar" data-id="${row.ID_Titulo}">
//                             <i class="bi bi-trash"></i> Eliminar
//                         </button>
//                     `;
//                 }
//             }
//         ],
//         "language": {
//             "sProcessing": "Procesando...",
//             "sLengthMenu": "Mostrar _MENU_ registros",
//             "sZeroRecords": "No se encontraron resultados",
//             "sEmptyTable": "No hay datos disponibles",
//             "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
//             "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
//             "sInfoFiltered": "(filtrado de _MAX_ registros)",
//             "sSearch": "Buscar:",
//             "oPaginate": {
//                 "sFirst": "Primero",
//                 "sPrevious": "Anterior",
//                 "sNext": "Siguiente",
//                 "sLast": "Último"
//             }
//         },
//         "paging": true,
//         "pageLength": 10,
//         "lengthChange": true,
//         "info": true,
//         "autoWidth": false
//     });

//     // Acciones con delegación de eventos
//     $('#dataTableTItulos tbody').on('click', '.btnEditar', function() {
//         const id = $(this).data('id');
//         // Aquí puedes abrir un modal o redirigir
//         console.log("Editar curso con ID:", id);
//         Swal.fire("Editar", "Aquí abrirías el modal para editar ID " + id, "info");
//     });

//     $('#dataTableTItulos tbody').on('click', '.btnEliminar', function() {
//         const id = $(this).data('id');
//         Swal.fire({
//             title: '¿Estás seguro?',
//             text: "Esta acción no se puede deshacer.",
//             icon: 'warning',
//             showCancelButton: true,
//             confirmButtonText: 'Sí, eliminar',
//             cancelButtonText: 'Cancelar'
//         }).then((result) => {
//             if (result.isConfirmed) {
//                 $.ajax({
//                     url: '../../../controllers/eliminarDetalleCursoController.php',
//                     type: 'POST',
//                     data: {
//                         id: id
//                     },
//                     success: function(response) {
//                         const res = JSON.parse(response);
//                         if (res.success) {
//                             Swal.fire('Eliminado', res.message, 'success');
//                             $('#dataTableDetallesCurso').DataTable().ajax.reload(
//                                 null, false);
//                         } else {
//                             Swal.fire('Error', res.message, 'error');
//                         }
//                     },
//                     error: function() {
//                         Swal.fire('Error', 'No se pudo conectar con el servidor.',
//                             'error');
//                     }
//                 });
//             }
//         });
//     });
// });


$(document).ready(function() {
    if ($.fn.DataTable.isDataTable('#dataTableTItulos')) {
        $('#dataTableTItulos').DataTable().clear().destroy();
    }

    const tabla = $('#dataTableTItulos').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        ajax: {
            url: '../../../../controllers/obtenerTitutosCursos.php',
            type: 'GET',
            dataSrc: function(json) {
                if (json.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al cargar los datos',
                        text: json.error
                    });
                    return [];
                }
                return json.data;
            }
        },
        columns: [{
                className: 'dt-control',
                orderable: false,
                data: null,
                defaultContent: '<i class="bi bi-caret-down-square-fill text-primary" style="cursor:pointer;"></i>',
                width: '30px'
            },
            {
                data: 'curso_title',
                title: 'Curso'
            }
        ],
        order: [
            [1, 'asc']
        ],
        language: {
            sProcessing: "Procesando...",
            sLengthMenu: "Mostrar _MENU_ registros",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "No hay datos disponibles",
            sInfo: "Mostrando _START_ a _END_ de _TOTAL_ registros",
            sInfoEmpty: "Mostrando 0 a 0 de 0 registros",
            sInfoFiltered: "(filtrado de _MAX_ registros)",
            sSearch: "Buscar:",
            oPaginate: {
                sFirst: "Primero",
                sPrevious: "Anterior",
                sNext: "Siguiente",
                sLast: "Último"
            }
        },
        pageLength: 10
    });

    // Mostrar títulos como child rows tipo acordeón
    $('#dataTableTItulos tbody').on('click', 'td.dt-control', function() {
        const tr = $(this).closest('tr');
        const row = tabla.row(tr);

        if (row.child.isShown()) {
            // Ocultar
            row.child.hide();
            tr.removeClass('shown');
            $(this).html('<i class="bi bi-caret-down-square-fill text-primary"></i>');
        } else {
            // Mostrar
            row.child(formatearTitulos(row.data())).show();
            tr.addClass('shown');
            $(this).html('<i class="bi bi-caret-up-square-fill text-danger"></i>');
        }
    });

    // Función para crear HTML de los títulos dentro del child row
    function formatearTitulos(data) {
        if (!data.titulos || data.titulos.length === 0) {
            return '<div class="p-2 text-muted">Este curso no tiene títulos registrados.</div>';
        }

        let html = `<div class="table-responsive p-3">
            <table class="table table-sm table-bordered table-sm w-100 mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Título</th>
                        <th>Descripción</th>
                        <th>Orden</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>`;

        data.titulos.forEach(titulo => {
            html += `
                <tr>
                    <td>${titulo.nom_titulo_temario}</td>
                    <td>${titulo.descripcion_temario}</td>
                    <td>${titulo.orden}</td>
                    <td>
                        <button class="btn btn-sm btn-warning me-1 btnEditar" data-id="${titulo.ID_Titulo}">
                            <i class="bi bi-pencil"></i> Editar
                        </button>
                        <button class="btn btn-sm btn-danger btnEliminar" data-id="${titulo.ID_Titulo}">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    </td>
                </tr>`;
        });

        html += '</tbody></table></div>';
        return html;
    }

    // Delegación de eventos para botones dentro del acordeón
    $('#dataTableTItulos tbody').on('click', '.btnEditar', function() {
        const id = $(this).data('id');
        Swal.fire("Editar", "Aquí abrirías el modal para editar ID " + id, "info");
    });

    $('#dataTableTItulos tbody').on('click', '.btnEliminar', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "Esta acción no se puede deshacer.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '../../../controllers/eliminarDetalleCursoController.php',
                    type: 'POST',
                    data: {
                        id: id
                    },
                    success: function(response) {
                        const res = JSON.parse(response);
                        if (res.success) {
                            Swal.fire('Eliminado', res.message, 'success');
                            tabla.ajax.reload(null, false);
                        } else {
                            Swal.fire('Error', res.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'No se pudo conectar con el servidor.',
                            'error');
                    }
                });
            }
        });
    });

    $('#formaddtitulos').submit(function(e) {
        e.preventDefault();

        // Validación básica del lado del cliente
        if (!validarFormulario()) {
            return false;
        }

        // Mostrar loader o indicador de carga
        Swal.fire({
            title: 'Procesando...',
            html: 'Por favor espere mientras guardamos la información',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Obtener los datos del formulario
        const formData = {
            curso_id: $('#searchInputID').val(),
            titulo: $('#nombreTitulostext').val(),
            descripcion: $('#descripciontext').val(),
            nivel: $('#nivelSubtema').val(),
            cuestionario_id: $('#searchInputID2').val()
        };

        // Enviar datos via AJAX
        $.ajax({
            url: '../../../../controllers/agregartituloscuestionarios.php',
            type: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function(response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: response.message ||
                            'Los datos se guardaron correctamente.',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        $('#formaddtitulos')[0].reset();
                        $('#searchInputID, #searchInputID2').val('');
                        $('#results, #results2').empty();
                        $('#dataTableTItulos').DataTable().ajax.reload(null, false);
                    });
                } else {
                    // Manejo mejorado de errores
                    if (response.errors || response.message) {
                        mostrarErrores(response.errors || response.message);
                    } else {
                        mostrarErrores('Error desconocido al procesar la respuesta');
                    }
                }
            },
            error: function(xhr, status, error) {
                Swal.close();

                try {
                    // Intentar parsear la respuesta como JSON
                    const response = JSON.parse(xhr.responseText);
                    if (response && (response.errors || response.message)) {
                        mostrarErrores(response.errors || response.message);
                    } else {
                        mostrarErrores(xhr.statusText || 'Error de conexión');
                    }
                } catch (e) {
                    // Si no es JSON válido, mostrar el texto plano
                    mostrarErrores(xhr.responseText || xhr.statusText ||
                        'Error desconocido');
                }
            }
        });
    });

    // Función para validar el formulario antes de enviar
    function validarFormulario() {
        let isValid = true;
        let errors = [];

        // Validar curso seleccionado
        if (!$('#searchInputID').val()) {
            errors.push('Debe seleccionar un curso de la lista');
            $('#searchInput').addClass('is-invalid');
            isValid = false;
        } else {
            $('#searchInput').removeClass('is-invalid');
        }

        // Validar título
        if (!$('#nombreTitulostext').val().trim()) {
            errors.push('El título es obligatorio');
            $('#nombreTitulostext').addClass('is-invalid');
            isValid = false;
        } else {
            $('#nombreTitulostext').removeClass('is-invalid');
        }

        // Validar cuestionario (si es obligatorio)
        if (!$('#searchInputID2').val()) {
            errors.push('Debe seleccionar un cuestionario de la lista');
            $('#searchInput2').addClass('is-invalid');
            isValid = false;
        } else {
            $('#searchInput2').removeClass('is-invalid');
        }

        // Mostrar errores si los hay
        if (errors.length > 0) {
            Swal.fire({
                icon: 'error',
                title: 'Error de validación',
                html: errors.join('<br>'),
                confirmButtonText: 'OK'
            });
        }

        return isValid;
    }

    // Función para mostrar errores de validación del servidor
    // Función mejorada para mostrar errores
    function mostrarErrores(errors) {
        let errorMessage = '';

        if (typeof errors === 'string') {
            // Si es un string directo
            errorMessage = errors;
        } else if (Array.isArray(errors)) {
            // Si es un array de errores
            errorMessage = errors.join('<br>');
        } else if (typeof errors === 'object' && errors !== null) {
            // Si es un objeto de errores (ej: {campo: "error"})
            errorMessage = Object.values(errors).join('<br>');
        } else {
            errorMessage = 'Error desconocido';
        }

        Swal.fire({
            icon: 'error',
            title: 'Error',
            html: errorMessage, // Usamos html para permitir saltos de línea
            confirmButtonText: 'OK'
        });
    }


});
</script>


<?php require('../../components/FooterAdmin.php'); ?>