<?php

// require_once '../../../controllers/uploads/vendor/autoload.php';

// // Crear PDF
// class MYPDF extends TCPDF
// {
//     // Cabecera personalizada
//     public function Header()
//     {
//         // Logo de la institución
//         $image_file = '../assets/img/LEARN-O.png'; // Ruta a tu logo
//         if (file_exists($image_file)) {
//             $this->Image($image_file, 15, 10, 30, '', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);
//         }

//         // Título
//         $this->SetFont('helvetica', 'B', 16);
//         $this->Cell(0, 15, 'CERTIFICADO DE APROBACIÓN', 0, 1, 'C');
//         $this->Ln(10);
//     }

//     // Pie de página
//     public function Footer()
//     {
//         $this->SetY(-25);
//         $this->SetFont('helvetica', 'I', 8);
//         $this->Cell(0, 10, 'Este certificado se expide electrónicamente y es válido sin firma manuscrita.', 0, 0, 'C');
//         $this->Ln();
//         $this->Cell(0, 10, 'Código de verificación: ' . uniqid('CERT-'), 0, 0, 'C');
//     }
// }
// function generarCertificado($pdf, $datosUsuario, $datosCurso, $calificacion)
// {
//     // Configuración del documento
//     $pdf->SetCreator('Sistema de Certificaciones');
//     $pdf->SetAuthor('Tu Institución');
//     $pdf->SetTitle('Certificado de Aprobación');
//     $pdf->SetSubject('Certificado del Curso');
//     $pdf->SetKeywords('Certificado, Curso, Aprobación');

//     // Margenes
//     $pdf->SetMargins(15, 40, 15);
//     $pdf->SetHeaderMargin(10);
//     $pdf->SetFooterMargin(20);


//     // Fecha de emisión: {$pdf->getAliasNumPage()}/{$pdf->getAliasNbPages()}
//     // Añadir página
//     $pdf->AddPage();
//     $fechahoy = date('d/m/Y');
//     // Contenido principal
//     $html = <<<EOD
// <style>
//     .titulo {
//         font-size: 14pt;
//         font-weight: bold;
//         text-align: center;
//         margin-bottom: 20px;
//     }
//     .subtitulo {
//         font-size: 12pt;
//         text-align: center;
//         margin-bottom: 30px;
//     }
//     .contenido {
//         font-size: 11pt;
//         text-align: justify;
//         margin-bottom: 20px;
//     }
//     .destacado {
//         font-size: 12pt;
//         font-weight: bold;
//         text-align: center;
//         margin: 10px 0;
//     }
//     .firma {
//         margin-top: 50px;
//         border-top: 1px solid #333;
//         width: 200px;
//         text-align: center;
//         padding-top: 10px;
//     }
// </style>


// <div class="subtitulo">Se hace constar que:</div>

// <div class="contenido" style="text-align: center;">
//     <strong>{$datosUsuario['nombre']}</strong><br>
//     Documento: {$datosUsuario['documento']}
// </div>

// <div class="contenido">
//     Ha completado satisfactoriamente el programa de formación <strong>{$datosCurso['titulo']}</strong> 
//     realizado entre el {$datosCurso['fecha_inicio']} 
//     y el {$datosCurso['fecha_fin']}, obteniendo una calificación final de:
// </div>

// <div class="destacado">
//     CALIFICACIÓN: {$calificacion}/10
// </div>

// <div class="contenido">
//     Este certificado acredita que el participante ha cumplido con todos los requisitos 
//     académicos establecidos por nuestra institución para la aprobación de este programa.
// </div>

// <div style="margin-top: 50px; text-align: center;">
//     <div style="margin-bottom: 60px;">

//         Fecha de emisión: {$fechahoy}
// </div>

// <div style="display: inline-block; margin: 0 30px;">
//     <div class="firma">_________________________</div>
//     <div>Director Académico</div>
// </div>

// <div style="display: inline-block; margin: 0 30px;">
//     <div class="firma">_________________________</div>
//     <div>Coordinador del Programa</div>
// </div>
// </div>
// EOD;

//     // Escribir contenido
//     $pdf->writeHTML($html, true, false, true, false, '');

//     // Añadir página de términos (opcional)
//     $pdf->AddPage();
//     $pdf->SetFont('helvetica', '', 10);
//     $pdf->MultiCell(0, 10, "TÉRMINOS Y CONDICIONES:\n\n1. Este certificado es válido por un año a partir de la fecha de
// emisión.\n2. Puede ser verificado en nuestro sistema ingresando el código de verificación.\n3. La institución se reserva
// el derecho de invalidar certificados en caso de irregularidades.", 0, 'J');

//     $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);



//     // Salida del PDF
//     $nombrecursante = $datosUsuario['nombre'];
//     generarCertificado($pdf, $datosUsuario, $datosCurso, $calificacion);
//     $pdf->Output('certificado_' . date(format: 'Ymd') . '_' . $nombrecursante . '.pdf', 'D');
// }


require_once __DIR__ . '/../../../controllers/uploads/vendor/autoload.php';


class CertificadoPDF extends TCPDF
{
    // Cabecera personalizada
    public function Header()
    {
        // Logo de la institución
        $image_file = '../../../assets/img/LEARN-O.png';
        if (file_exists($image_file)) {
            $this->Image($image_file, 15, 10, 30, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }

        // Título
        $this->SetFont('helvetica', 'B', 16);
        $this->Cell(0, 15, 'CERTIFICADO DE APROBACIÓN', 0, 1, 'C');
        $this->Ln(10);
    }

    // Pie de página
    public function Footer()
    {
        $this->SetY(-25);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Este certificado se expide electrónicamente y es válido sin firma manuscrita.', 0, 0, 'C');
        $this->Ln();
        $this->Cell(0, 10, 'Código de verificación: ' . uniqid('CERT-'), 0, 0, 'C');
    }

    // Método para generar contenido
    public function generarContenido($datosUsuario, $datosCurso, $calificacion)
    {
        // Validación básica
        if (empty($datosUsuario['nombre'])) {
            throw new Exception('Datos de usuario incompletos');
        }

        // Configuración
        $this->SetCreator('Sistema de Certificaciones');
        $this->SetAuthor('Tu Institución');
        $this->SetTitle('Certificado de Aprobación');
        $this->SetMargins(15, 40, 15);
        $this->SetHeaderMargin(10);
        $this->SetFooterMargin(20);

        // Primera página
        $this->AddPage();
        $fechahoy = date('d/m/Y');

        $html = <<<EOD
<style>
    .titulo { font-size: 14pt; font-weight: bold; text-align: center; margin-bottom: 20px; }
    .subtitulo { font-size: 12pt; text-align: center; margin-bottom: 30px; }
    .contenido { font-size: 11pt; text-align: justify; margin-bottom: 20px; }
    .destacado { font-size: 12pt; font-weight: bold; text-align: center; margin: 10px 0; }
    .firma { margin-top: 50px; border-top: 1px solid #333; width: 200px; text-align: center; padding-top: 10px; }
</style>

<div class="subtitulo">Se hace constar que:</div>

<div class="contenido" style="text-align: center;">
    <strong>{$datosUsuario['nombre']}</strong><br>
    Documento: {$datosUsuario['documento']}
</div>

<div class="contenido">
    Ha completado satisfactoriamente el programa de formación <strong>{$datosCurso['titulo']}</strong> 
    realizado entre el {$datosCurso['fecha_inicio']} y el {$datosCurso['fecha_fin']}, 
    obteniendo una calificación final de:
</div>

<div class="destacado">
    CALIFICACIÓN: {$calificacion}/10
</div>

<div class="contenido">
    Este certificado acredita que el participante ha cumplido con todos los requisitos 
    académicos establecidos por nuestra institución para la aprobación de este programa.
</div>

<div style="margin-top: 50px; text-align: center;">
    <div style="margin-bottom: 60px;">
        Fecha de emisión: {$fechahoy}
    </div>
    <div style="display: inline-block; margin: 0 30px;">
        <div class="firma">_________________________</div>
        <div>Director Académico</div>
    </div>
    <div style="display: inline-block; margin: 0 30px;">
        <div class="firma">_________________________</div>
        <div>Coordinador del Programa</div>
    </div>
</div>
EOD;

        $this->writeHTML($html, true, false, true, false, '');

        // Página de términos
        // $this->AddPage();
        // $this->SetFont('helvetica', '', 10);
        // $this->MultiCell(0, 10, "TÉRMINOS Y CONDICIONES:\n\n1. Este certificado es válido por un año a partir de la fecha de emisión.\n2. Puede ser verificado en nuestro sistema ingresando el código de verificación.\n3. La institución se reserva el derecho de invalidar certificados en caso de irregularidades.", 0, 'J');
    }
}

// Función para generar y descargar el PDF
function generarCertificadoPDF($datosUsuario, $datosCurso, $calificacion)
{
    try {
        // Limpiar buffers
        while (ob_get_level()) ob_end_clean();

        // Crear PDF
        $pdf = new CertificadoPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf->generarContenido($datosUsuario, $datosCurso, $calificacion);

        // Generar nombre seguro
        $nombreArchivo = 'certificado_' . date('Ymd') . '_' .
            preg_replace('/[^a-zA-Z0-9-_]/', '_', $datosUsuario['nombre']) . '.pdf';

        // Salida
        $pdf->Output($nombreArchivo, 'D');
        exit;
    } catch (Exception $e) {
        die('Error al generar certificado: ' . $e->getMessage());
    }
}