<?php




require_once __DIR__ . '/../../../controllers/uploads/vendor/autoload.php';



class CertificadoPDF extends TCPDF
{
    private $amarillo = array(255, 204, 0);
    private $azul_oscuro = array(0, 51, 102);
    private $gris_medio = array(100, 100, 100);
    
    public function __construct($orientation = 'L', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false, $pdfa = false)
    {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache, $pdfa);
        $this->SetMargins(15, 20, 15);
        $this->SetAutoPageBreak(FALSE); // Importante para una sola página
    }

    public function Header()
    {
        // Fondo con degradado (efecto visual)
        $this->SetFillColorArray($this->amarillo);
        $this->Rect(0, 0, $this->getPageWidth(), 15, 'F');
        
        // Logo centrado
        $logo_file = 'https://marjetactivity.com.mx/cursos-promotoria/src/assets/img/YELLO.jpg';
        $this->Image($logo_file, ($this->getPageWidth()-70)/2, 18, 70, 0, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        
        // Elemento decorativo
        $this->SetLineStyle(array('width' => 0.5, 'color' => $this->amarillo));
        $this->Line(30, 45, $this->getPageWidth()-30, 45);
    }

    public function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->SetTextColorArray($this->gris_medio);
        $this->Cell(0, 10, 'Certificado digital válido - Código: YELLO-'.strtoupper(uniqid()), 0, 0, 'C');
    }

    public function generarContenido($datosUsuario, $datosCurso, $calificacion)
    {
        $this->AddPage();
        
        // Marco principal con efecto
        $this->SetLineStyle(array('width' => 0.5, 'color' => $this->amarillo));
        $this->RoundedRect(20, 30, $this->getPageWidth()-40, $this->getPageHeight()-50, 5, '1111', 'D');
        
        // Texto del certificado
        $this->SetY(60);
        $this->SetFont('helvetica', '', 16);
        $this->SetTextColorArray($this->gris_medio);
        $this->Cell(0, 10, 'LA ORGANIZACIÓN YELLO MKT GROUP CERTIFICA QUE:', 0, 1, 'C');
        
        // Nombre del participante
        $this->SetY(80);
        $this->SetFont('helvetica', 'B', 28);
        $this->SetTextColorArray($this->azul_oscuro);
        $this->Cell(0, 15, mb_strtoupper($datosUsuario['nombre']), 0, 1, 'C');
        
        // Texto descriptivo
        $this->SetFont('helvetica', '', 14);
        $this->SetTextColorArray($this->gris_medio);
        $this->Cell(0, 8, 'ha completado satisfactoriamente el programa:', 0, 1, 'C');
        
        // Nombre del curso
        $this->SetFont('helvetica', 'B', 18);
        $this->SetTextColorArray($this->azul_oscuro);
        $this->Cell(0, 10, '"'.mb_strtoupper($datosCurso['titulo']).'"', 0, 1, 'C');
        
        // Detalles del curso
        $this->SetFont('helvetica', '', 12);
        $this->SetTextColorArray($this->gris_medio);
        $this->Cell(0, 8, 'Finalizado el día '.formatearFechaEspanol($datosCurso['fecha_fin']), 0, 1, 'C');
        
        // Calificación
        $this->SetY(140);
        $this->SetFont('helvetica', 'B', 14);
        $this->Cell(0, 8, 'Calificación obtenida:', 0, 1, 'C');
        
        $this->SetFont('helvetica', 'B', 36);
        $this->SetTextColorArray($this->amarillo);
        $this->Cell(0, 20, $calificacion.'/10', 0, 1, 'C');
        
       
        
        // Configuración de firmas
$y_position = 170; // Posición fija en Y
$line_length = 60; // Longitud de la línea de firma
$text_offset_x = 25; // Ajuste horizontal del texto
$text_offset_y1 = 5; // Espacio después de la línea para nombre
$text_offset_y2 = 10; // Espacio después de la línea para cargo

// Firma Instructor 1
$this->Line($this->getPageWidth()/3 - $line_length/2, $y_position, 
            $this->getPageWidth()/3 + $line_length/2, $y_position);
$this->SetFont('helvetica', '', 9);
$this->SetTextColorArray($this->gris_medio);
$this->Text($this->getPageWidth()/3 - $text_offset_x, $y_position + $text_offset_y1, 'Personal 1');
$this->Text($this->getPageWidth()/3 - $text_offset_x + 5, $y_position + $text_offset_y2, 'Instructora');

// Firma Instructor 2
$this->Line($this->getPageWidth()*2/3 - $line_length/2, $y_position, 
            $this->getPageWidth()*2/3 + $line_length/2, $y_position);
$this->Text($this->getPageWidth()*2/3 - $text_offset_x, $y_position + $text_offset_y1, 'Personal 2');
$this->Text($this->getPageWidth()*2/3 - $text_offset_x + 5, $y_position + $text_offset_y2, 'Instructor');
        
        // Sello de validación
        $this->SetY(180);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetTextColor(255, 255, 255);
        $this->SetFillColorArray($this->azul_oscuro);
        $this->Cell(40, 40, 'VÁLIDO', 1, 1, 'C', true, '', 0, false, 'T', 'M');
    }
}

function formatearFechaEspanol($fecha_mysql)
{
    $fecha = new DateTime($fecha_mysql);
    $meses = [1=>'Enero',2=>'Febrero',3=>'Marzo',4=>'Abril',5=>'Mayo',6=>'Junio',
              7=>'Julio',8=>'Agosto',9=>'Septiembre',10=>'Octubre',11=>'Noviembre',12=>'Diciembre'];
    return $fecha->format('d').' de '.$meses[(int)$fecha->format('n')].' de '.$fecha->format('Y');
}

function generarCertificadoYello($datosUsuario, $datosCurso, $calificacion)
{
    try {
        $pdf = new CertificadoPDF('L', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->SetTitle('Certificado de Participación');
        $pdf->SetAuthor('Yello MKT Group');
        
        // Valores por defecto
        if (!isset($datosCurso['horas'])) $datosCurso['horas'] = 40;
        
        $pdf->generarContenido($datosUsuario, $datosCurso, $calificacion);
        
        $nombreArchivo = 'Certificado_'.preg_replace('/[^a-zA-Z0-9]/', '_', $datosUsuario['nombre']).'.pdf';
        $pdf->Output($nombreArchivo, 'D');
        exit;
    } catch (Exception $e) {
        die('Error: '.$e->getMessage());
    }
}