<?php
session_start();
require_once '../config/config.php'; // Asegúrate de que esta conexión esté bien configurada

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $curso_id = isset($_POST['curso_id']) ? intval($_POST['curso_id']) : 0;
    $progreso = isset($_POST['progreso']) ? intval($_POST['progreso']) : 0;
    $usuario_id = $_SESSION['usuario_id'] ?? 0; // Asegúrate de tener la ID del usuario en la sesión

    if ($usuario_id > 0 && $curso_id > 0 && $progreso >= 0 && $progreso <= 100) {
        // Guardar el progreso en la sesión
        $_SESSION["progreso_curso_{$curso_id}"] = $progreso;

        // Guardar el progreso en la base de datos
        $update_progreso = "UPDATE usuarios_cursos SET progreso = ?
                            WHERE usuario_id = ? AND curso_id = ? AND estado_curso = 'En curso'
                            ORDER BY fecha_inscripcion DESC LIMIT 1"; // Asumiendo que quieres actualizar el intento más reciente en curso

        $stmt_update = $conexion->prepare($update_progreso);
        $stmt_update->bind_param("iii", $progreso, $usuario_id, $curso_id);

        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error al actualizar el progreso en la base de datos: ' . $stmt_update->error]);
        }

        $stmt_update->close();
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Datos de progreso inválidos.']);
    }

    $conexion->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Petición no válida.']);
}



// session_start();
// require_once '../config/config.php';

// header('Content-Type: application/json');

// if ($_SERVER['REQUEST_METHOD'] === 'POST') {
//     // Obtener el contenido JSON enviado
//     $json = file_get_contents('php://input');
//     $data = json_decode($json, true);

//     // Validar datos básicos
//     if (json_last_error() !== JSON_ERROR_NONE) {
//         echo json_encode(['status' => 'error', 'message' => 'JSON inválido']);
//         exit;
//     }

//     $curso_id = isset($data['curso_id']) ? intval($data['curso_id']) : 0;
//     $usuario_id = $_SESSION['usuario_id'] ?? 0;
//     $accion = isset($data['accion']) ? $data['accion'] : '';

//     if ($usuario_id <= 0) {
//         echo json_encode(['status' => 'error', 'message' => 'Usuario no autenticado']);
//         exit;
//     }

//     if ($curso_id <= 0) {
//         echo json_encode(['status' => 'error', 'message' => 'ID de curso inválido']);
//         exit;
//     }

//     // Manejar diferentes acciones
//     switch ($accion) {
//         case 'actualizar_progreso_tema':
//             $tema_index = isset($data['tema_index']) ? intval($data['tema_index']) : -1;
//             $temas_completados = isset($data['temas_completados']) ? intval($data['temas_completados']) : 0;
//             $total_temas = isset($data['total_temas']) ? intval($data['total_temas']) : 1;
//             $progreso = isset($data['progreso']) ? intval($data['progreso']) : 0;

//             if ($tema_index < 0) {
//                 echo json_encode(['status' => 'error', 'message' => 'Índice de tema inválido']);
//                 exit;
//             }

//             // Guardar en sesión
//             $_SESSION["progreso_curso_{$curso_id}_tema_{$tema_index}"] = [
//                 'completados' => $temas_completados,
//                 'total' => $total_temas,
//                 'progreso' => $progreso
//             ];

//             // Guardar en base de datos
//             try {
//                 // Primero verificar si ya existe un registro para este tema
//                 $check_query = "SELECT id FROM usuarios_cursos_temas 
//                                WHERE usuario_id = ? AND curso_id = ? AND tema_index = ?";
//                 $stmt_check = $conexion->prepare($check_query);
//                 $stmt_check->bind_param("iii", $usuario_id, $curso_id, $tema_index);
//                 $stmt_check->execute();
//                 $result = $stmt_check->get_result();
//                 $stmt_check->close();

//                 if ($result->num_rows > 0) {
//                     // Actualizar registro existente
//                     $update_query = "UPDATE usuarios_cursos_temas 
//                                    SET temas_completados = ?, total_temas = ?, progreso = ?, fecha_actualizacion = NOW()
//                                    WHERE usuario_id = ? AND curso_id = ? AND tema_index = ?";
//                     $stmt = $conexion->prepare($update_query);
//                     $stmt->bind_param("iiiiii", $temas_completados, $total_temas, $progreso, $usuario_id, $curso_id, $tema_index);
//                 } else {
//                     // Insertar nuevo registro
//                     $insert_query = "INSERT INTO usuarios_cursos_temas 
//                                     (usuario_id, curso_id, tema_index, temas_completados, total_temas, progreso, fecha_inscripcion, fecha_actualizacion)
//                                     VALUES (?, ?, ?, ?, ?, ?, NOW(), NOW())";
//                     $stmt = $conexion->prepare($insert_query);
//                     $stmt->bind_param("iiiiii", $usuario_id, $curso_id, $tema_index, $temas_completados, $total_temas, $progreso);
//                 }

//                 if ($stmt->execute()) {
//                     // Actualizar progreso general del curso
//                     actualizarProgresoGeneral($conexion, $usuario_id, $curso_id);
//                     echo json_encode(['status' => 'success']);
//                 } else {
//                     echo json_encode(['status' => 'error', 'message' => 'Error al guardar progreso: ' . $stmt->error]);
//                 }

//                 $stmt->close();
//             } catch (Exception $e) {
//                 echo json_encode(['status' => 'error', 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
//             }
//             break;

//         case 'actualizar_progreso_general':
//             $progreso = isset($data['progreso']) ? intval($data['progreso']) : 0;

//             if ($progreso < 0 || $progreso > 100) {
//                 echo json_encode(['status' => 'error', 'message' => 'Progreso inválido']);
//                 exit;
//             }

//             // Guardar en sesión
//             $_SESSION["progreso_curso_{$curso_id}"] = $progreso;

//             // Guardar en base de datos
//             $update_progreso = "UPDATE usuarios_cursos SET progreso = ?
//                               WHERE usuario_id = ? AND curso_id = ? AND estado_curso = 'En curso'
//                               ORDER BY fecha_inscripcion DESC LIMIT 1";

//             $stmt_update = $conexion->prepare($update_progreso);
//             $stmt_update->bind_param("iii", $progreso, $usuario_id, $curso_id);

//             if ($stmt_update->execute()) {
//                 echo json_encode(['status' => 'success']);
//             } else {
//                 echo json_encode(['status' => 'error', 'message' => 'Error al actualizar el progreso general: ' . $stmt_update->error]);
//             }

//             $stmt_update->close();
//             break;

//         default:
//             echo json_encode(['status' => 'error', 'message' => 'Acción no válida']);
//             break;
//     }

//     $conexion->close();
// } else {
//     echo json_encode(['status' => 'error', 'message' => 'Método no permitido']);
// }

// // Función para actualizar el progreso general del curso
// function actualizarProgresoGeneral($conexion, $usuario_id, $curso_id)
// {
//     // Calcular el progreso general basado en todos los temas
//     $query = "SELECT SUM(progreso) as suma_progreso, COUNT(*) as total_temas 
//               FROM usuarios_cursos_temas 
//               WHERE usuario_id = ? AND curso_id = ?";

//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("ii", $usuario_id, $curso_id);
//     $stmt->execute();
//     $result = $stmt->get_result();
//     $data = $result->fetch_assoc();
//     $stmt->close();

//     if ($data && $data['total_temas'] > 0) {
//         $progreso_general = round($data['suma_progreso'] / $data['total_temas']);

//         // Actualizar el progreso general en la tabla usuarios_cursos
//         $update_query = "UPDATE usuarios_cursos SET progreso = ?
//                         WHERE usuario_id = ? AND curso_id = ? AND estado_curso = 'En curso'
//                         ORDER BY fecha_inscripcion DESC LIMIT 1";

//         $stmt_update = $conexion->prepare($update_query);
//         $stmt_update->bind_param("iii", $progreso_general, $usuario_id, $curso_id);
//         $stmt_update->execute();
//         $stmt_update->close();
//     }
// }