<?php
header('Content-Type: application/json');
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);
session_start(); // Iniciar sesión si aún no está iniciada

// Verificar si el usuario está autenticado (ejemplo básico)
if (!isset($_SESSION['usuario_id'])) {
    http_response_code(401); // No autorizado
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// Verificar y sanitizar los datos recibidos
$promotoria_id = filter_input(INPUT_POST, 'promotoria_id', FILTER_SANITIZE_NUMBER_INT);
$curso_id = filter_input(INPUT_POST, 'curso_id', FILTER_SANITIZE_NUMBER_INT);

if (!$promotoria_id || !$curso_id) {
    http_response_code(400); // Solicitud incorrecta
    echo json_encode(['success' => false, 'message' => 'ID de promotoria o curso no válido.']);
    exit;
}

// Verificar si el curso ya está asignado a la promotoria
$check_sql = "SELECT * FROM cursos_promotorias WHERE promotoria_id = ? AND curso_id = ?";
$check_stmt = $conexion->prepare($check_sql);
$check_stmt->bind_param("ii", $promotoria_id, $curso_id);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows > 0) {
    echo json_encode(['success' => false, 'message' => 'Este curso ya está asignado a esta promotoria.']);
} else {
    // Utilizar prepared statement para la inserción
    $insert_sql = "INSERT INTO cursos_promotorias (promotoria_id, curso_id) VALUES (?, ?)";
    $insert_stmt = $conexion->prepare($insert_sql);
    $insert_stmt->bind_param("ii", $promotoria_id, $curso_id);

    if ($insert_stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Curso asignado exitosamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al asignar el curso: ' . $insert_stmt->error]);
    }

    $insert_stmt->close();
}

$check_stmt->close();
$conexion->close();
