<?php

// // Iniciar sesión para obtener datos del usuario
// session_start();

// // Verificar autenticación
// if (!isset($_SESSION['usuario_id'])) {
//     die('Acceso no autorizado');
// }

// // Cargar TCPDF
// require_once './uploads/vendor/autoload.php'; // Ruta correcta según tu instalación

// // Obtener parámetros
// $curso_id = intval($_GET['curso_id']);
// $calificacion = isset($_GET['calificacion']) ? floatval($_GET['calificacion']) : 0;
// $calificacion = min(10, max(0, $calificacion)); // Asegurar rango 0-10

// // Datos de ejemplo (debes reemplazar con consultas reales a tu BD)
// $datosUsuario = [
//     'nombre' => $_SESSION["nombre_completo"] ?? 'Nombre del Participante',
//     'documento' => $_SESSION['usuario_documento'] ?? 'ID-000000'
// ];

// $datosCurso = [
//     'titulo' => 'Nombre del Curso Completo',
//     'duracion' => '40 horas',
//     'fecha_inicio' => '01/01/2023',
//     'fecha_fin' => '31/01/2023'
// ];

// // Crear PDF
// class MYPDF extends TCPDF
// {
//     // Cabecera personalizada
//     public function Header()
//     {
//         // Logo de la institución
//         $image_file = 'assets/img/logo-institucion.jpg'; // Ruta a tu logo
//         if (file_exists($image_file)) {
//             $this->Image($image_file, 15, 10, 30, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
//         }

//         // Título
//         $this->SetFont('helvetica', 'B', 16);
//         $this->Cell(0, 15, 'CERTIFICADO DE APROBACIÓN', 0, 1, 'C');
//         $this->Ln(10);
//     }

//     // Pie de página
//     public function Footer()
//     {
//         $this->SetY(-25);
//         $this->SetFont('helvetica', 'I', 8);
//         $this->Cell(0, 10, 'Este certificado se expide electrónicamente y es válido sin firma manuscrita.', 0, 0, 'C');
//         $this->Ln();
//         $this->Cell(0, 10, 'Código de verificación: ' . uniqid('CERT-'), 0, 0, 'C');
//     }
// }

// // Crear nuevo documento
// $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// // Configuración del documento
// $pdf->SetCreator('Sistema de Certificaciones');
// $pdf->SetAuthor('Tu Institución');
// $pdf->SetTitle('Certificado de Aprobación');
// $pdf->SetSubject('Certificado del Curso');
// $pdf->SetKeywords('Certificado, Curso, Aprobación');

// // Margenes
// $pdf->SetMargins(15, 40, 15);
// $pdf->SetHeaderMargin(10);
// $pdf->SetFooterMargin(20);


// // Fecha de emisión: {$pdf->getAliasNumPage()}/{$pdf->getAliasNbPages()}
// // Añadir página
// $pdf->AddPage();
// $fechahoy = date('d/m/Y');
// // Contenido principal
// $html = <<<EOD
// <style>
//     .titulo {
//         font-size: 14pt;
//         font-weight: bold;
//         text-align: center;
//         margin-bottom: 20px;
//     }
//     .subtitulo {
//         font-size: 12pt;
//         text-align: center;
//         margin-bottom: 30px;
//     }
//     .contenido {
//         font-size: 11pt;
//         text-align: justify;
//         margin-bottom: 20px;
//     }
//     .destacado {
//         font-size: 12pt;
//         font-weight: bold;
//         text-align: center;
//         margin: 10px 0;
//     }
//     .firma {
//         margin-top: 50px;
//         border-top: 1px solid #333;
//         width: 200px;
//         text-align: center;
//         padding-top: 10px;
//     }
// </style>

// <div class="titulo">CERTIFICADO DE APROBACIÓN</div>
// <div class="subtitulo">Se hace constar que:</div>

// <div class="contenido" style="text-align: center;">
//     <strong>{$datosUsuario['nombre']}</strong><br>
//     Documento: {$datosUsuario['documento']}
// </div>

// <div class="contenido">
//     Ha completado satisfactoriamente el programa de formación <strong>{$datosCurso['titulo']}</strong>, 
//     con una duración de {$datosCurso['duracion']}, realizado entre el {$datosCurso['fecha_inicio']} 
//     y el {$datosCurso['fecha_fin']}, obteniendo una calificación final de:
// </div>

// <div class="destacado">
//     CALIFICACIÓN: {$calificacion}/10
// </div>

// <div class="contenido">
//     Este certificado acredita que el participante ha cumplido con todos los requisitos 
//     académicos establecidos por nuestra institución para la aprobación de este programa.
// </div>

// <div style="margin-top: 50px; text-align: center;">
//     <div style="margin-bottom: 60px;">

//         Fecha de emisión: {$fechahoy}
// </div>

// <div style="display: inline-block; margin: 0 30px;">
//     <div class="firma">_________________________</div>
//     <div>Director Académico</div>
// </div>

// <div style="display: inline-block; margin: 0 30px;">
//     <div class="firma">_________________________</div>
//     <div>Coordinador del Programa</div>
// </div>
// </div>
// EOD;

// // Escribir contenido
// $pdf->writeHTML($html, true, false, true, false, '');

// // Añadir página de términos (opcional)
// $pdf->AddPage();
// $pdf->SetFont('helvetica', '', 10);
// $pdf->MultiCell(0, 10, "TÉRMINOS Y CONDICIONES:\n\n1. Este certificado es válido por un año a partir de la fecha de
// emisión.\n2. Puede ser verificado en nuestro sistema ingresando el código de verificación.\n3. La institución se reserva
// el derecho de invalidar certificados en caso de irregularidades.", 0, 'J');

// // Salida del PDF
// $nombrecursante = $datosUsuario['nombre'];
// $pdf->Output('certificado_' . date(format: 'Ymd') . '_' . $nombrecursante . '.pdf', 'D');










// session_start();

// require '../config/config.php'; // Archivo con tu conexión PDO


// // 1. Validación de parámetros y sesión
// if (!isset($_SESSION['usuario_id'])) {
//     die(json_encode(['error' => 'Acceso no autorizado']));
// }

// $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT, [
//     'options' => ['min_range' => 1]
// ]);

// $calificacion = filter_input(INPUT_GET, 'calificacion', FILTER_VALIDATE_FLOAT, [
//     'options' => ['min_range' => 0, 'max_range' => 10]
// ]);

// if (!$curso_id || $calificacion === false) {
//     die(json_encode(['error' => 'Parámetros inválidos']));
// }

// // 2. Actualización en base de datos
// try {
//     // Verificar que el usuario está inscrito y puede recibir certificado
//     $query = "UPDATE usuarios_cursos SET 
//               estado_curso = 'Completado', 
//               calificacion_final = ?,
//               fecha_finalizacion = NOW()
//               WHERE usuario_id = ? 
//               AND curso_id = ?
//               AND estado_curso != 'Completado'";


//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("dii", $calificacion, $_SESSION['usuario_id'], $curso_id);
//     $stmt->execute();

//     if ($stmt->affected_rows  === 0) {
//         die('No se pudo actualizar el estado del curso');
//     }
//     $stmt->close();

//     // 4. Obtener datos reales del curso
//     $query = "SELECT 
//               c.curso_title, 
//               c.fecha_inicio,
//               uc.fecha_finalizacion,
//               DATE(uc.fecha_inscripcion) AS solo_fecha
//               FROM cursos c
//               JOIN usuarios_cursos uc ON c.curso_id = uc.curso_id
//               WHERE c.curso_id = ?
//               AND uc.usuario_id = ?";

//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("ii", $curso_id, $_SESSION['usuario_id']);
//     $stmt->execute();
//     $result = $stmt->get_result();
//     $datosCurso = $result->fetch_assoc();
//     $stmt->close();

//     if (!$datosCurso) {
//         die(json_encode(['error' => 'Datos del curso no encontrados']));
//     }

//     // 4. Obtener datos promotoria del usuario
//     $query = "SELECT u.promotoria_id, u.nombre_completo, p.nombre_promotoria FROM usuarios u JOIN promotorias p ON p.promotoria_id = u.promotoria_id WHERE u.usuario_id = ?";
//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("i",  $_SESSION['usuario_id']);
//     $stmt->execute();
//     $result = $stmt->get_result();
//     $datosPromotoria = $result->fetch_assoc();
//     $stmt->close();

//     if (!$datosPromotoria) {
//         die(json_encode(['error' => 'Datos del curso no encontrados']));
//     }
//     // Datos de ejemplo (debes reemplazar con consultas reales a tu BD)
//     $datosUsuario = [
//         'nombre' => $_SESSION["nombre_completo"] ?? 'Nombre del Participante',
//         'documento' => $_SESSION['usuario_documento'] ?? 'ID-000000',
//         'promotoria' => $datosPromotoria['promotoria_id']
//     ];

//     $datosCurso = [
//         'titulo' => $datosCurso['curso_title'],
//         'fecha_inicio' => $datosCurso['solo_fecha'],
//         'fecha_fin' => $datosCurso['fecha_finalizacion']
//     ];


//     // Ruta al archivo del diseño
//     $ruta_diseño = "../app/view/diseños/{$datosUsuario['promotoria']}.php";

//     // Verifica si existe, si no, usa uno genérico
//     if (!file_exists($ruta_diseño)) {
//         $ruta_diseño = __DIR__ . "/../views/diseños_certificados/default.php";
//     }

//     include_once $ruta_diseño;
//     // Crear nuevo documento

// } catch (Exception $e) {
//     die(json_encode(['error' => 'Error en base de datos: ' . $e->getMessage()]));
// }



session_start();
require '../config/config.php'; // Conexión con MySQLi

// 1. Validación de sesión y parámetros
if (!isset($_SESSION['usuario_id'])) {
    header('Content-Type: application/json');
    die(json_encode(['error' => 'Acceso no autorizado']));
}

$curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT, ['options' => ['min_range' => 1]]);
$calificacion = filter_input(INPUT_GET, 'calificacion', FILTER_VALIDATE_FLOAT, ['options' => ['min_range' => 0, 'max_range' => 10]]);

$estadoFinal = ($calificacion >= 6.0) ? 'Completado' : 'En curso';

if (!$curso_id || $calificacion === false) {
    header('Content-Type: application/json');
    die(json_encode(['error' => 'Parámetros inválidos']));
}

try {
    // 2. Actualización del estado del curso
    $query = "UPDATE usuarios_cursos SET 
                estado_curso = ?, 
                calificacion_final = ?,
                fecha_finalizacion = NOW()
              WHERE usuario_id = ? AND curso_id = ? AND estado_curso != 'Completado'";
    $stmt = $conexion->prepare($query);
    $stmt->bind_param("sdii", $estadoFinal, $calificacion, $_SESSION['usuario_id'], $curso_id);
    $stmt->execute();
    if ($stmt->affected_rows === 0) {
        header('Content-Type: application/json');
        die(json_encode(['error' => 'No se pudo actualizar el estado del curso']));
    }
    $stmt->close();

    // 3. Datos del curso
    $query = "SELECT 
                c.curso_title, 
                c.fecha_inicio as fecha_inicio,
                uc.fecha_finalizacion as fecha_fin
              FROM cursos c
              JOIN usuarios_cursos uc ON c.curso_id = uc.curso_id
              WHERE c.curso_id = ? AND uc.usuario_id = ?";
    $stmt = $conexion->prepare($query);
    $stmt->bind_param("ii", $curso_id, $_SESSION['usuario_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $datosCurso = $result->fetch_assoc();
    $stmt->close();
    if (!$datosCurso) {
        header('Content-Type: application/json');
        die(json_encode(['error' => 'Datos del curso no encontrados']));
    }

    // 4. Datos de la promotoria
    $query = "SELECT u.promotoria_id, u.nombre_completo, p.nombre_promotoria 
              FROM usuarios u 
              JOIN promotorias p ON p.promotoria_id = u.promotoria_id 
              WHERE u.usuario_id = ?";
    $stmt = $conexion->prepare($query);
    $stmt->bind_param("i", $_SESSION['usuario_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $datosPromotoria = $result->fetch_assoc();
    $stmt->close();
    if (!$datosPromotoria) {
        header('Content-Type: application/json');
        die(json_encode(['error' => 'Datos de promotoría no encontrados']));
    }

    // 5. Preparar datos para el certificado
    $datosUsuario = [
        'nombre' => $_SESSION["nombre_completo"] ?? 'Nombre del Participante',
        'documento' => $_SESSION['usuario_documento'] ?? 'ID-000000',
        'promotoria' => $datosPromotoria['promotoria_id']
    ];
    $datosCurso = [
        'titulo' => $datosCurso['curso_title'],
        'fecha_inicio' => $datosCurso['fecha_inicio'],
        'fecha_fin' => $datosCurso['fecha_fin'],
        'promotoria' => $datosPromotoria['nombre_promotoria']
    ];

    // 6. Selección del diseño
    $ruta_base = '../app/view/diseños/';
    $ruta_diseño = $ruta_base . $datosUsuario['promotoria'] . '.php';
    $ruta_default = $ruta_base . 'default.php';

    if (!file_exists($ruta_diseño)) {
        if (!file_exists($ruta_default)) {
            header('Content-Type: application/json');
            die(json_encode(['error' => 'Plantilla de certificado no disponible']));
        }
        $ruta_diseño = $ruta_default;
    }

    // 7. Limpiar buffers y configurar encabezados para salida PDF
    while (ob_get_level()) ob_end_clean();
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="certificado.pdf"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Expires: 0');

    // 8. Incluir diseño y llamar función de generación
    require_once $ruta_diseño;

    if (function_exists('generarCertificadoYello')) {
        generarCertificadoYello($datosUsuario, $datosCurso, $calificacion);
    } else {
        die(json_encode(['error' => 'No se encontró la función para generar el certificado.']));
    }
} catch (Exception $e) {
    header('Content-Type: application/json');
    die(json_encode(['error' => 'Error en el sistema: ' . $e->getMessage()]));
}