<?php
header('Content-Type: application/json');
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);
session_start(); // Iniciar sesión si aún no está iniciada

// Verificar si el usuario está autenticado (ejemplo básico)
if (!isset($_SESSION['usuario_id'])) {
    http_response_code(401); // No autorizado
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$empresa_id = filter_input(INPUT_POST, 'empresa_id', FILTER_SANITIZE_NUMBER_INT);

$nombre_promotoria = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_FULL_SPECIAL_CHARS);


// Utilizar prepared statement para la inserción
$sql = "INSERT INTO promotorias (empresa_id,nombre_promotoria) VALUES (?,?)";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("is", $empresa_id, $nombre_promotoria);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Promotoria creada exitosamente.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al crear la promotoria: ' . $stmt->error]);
}

$stmt->close();
$conexion->close();
