<?php


session_start();
header("Cache-Control: no-cache, must-revalidate"); // Evita que se almacene en caché
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Fecha en el pasado
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);

function validarCorreo($correo)
{
    $pattern = "/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/";
    return preg_match($pattern, $correo);
}


if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $emailusu = trim(htmlspecialchars($_POST["inputEmail"]));
    $password = trim($_POST["inputPassword"]);

    // 🔹 **Validar RFC antes de hacer la consulta**
    if (!validarCorreo($emailusu)) {
        echo json_encode(["status" => "error", "message" => "RFC inválido."]);
        exit;
    }

    // 🔹 **Validar que los campos no estén vacíos**
    if (empty($emailusu) || empty($password)) {
        echo json_encode(["status" => "error", "message" => "Completa todos los campos."]);
        exit;
    }

    try {
        // 🔹 **Consulta optimizada incluyendo el estado del usuario**
        $sql = "SELECT u.usuario_id, u.nombre_completo, u.email, u.password,u.promotoria_id, u.puesto_id, u.rol_id, u.status FROM usuarios u 
                WHERE u.email = ? 
                LIMIT 1";
        $stmt = $conexion->prepare($sql);
        if (!$stmt) {
            throw new Exception("Error en la consulta.");
        }

        $stmt->bind_param("s", $emailusu);
        $stmt->execute();
        $resultado = $stmt->get_result();

        if ($resultado->num_rows === 1) {
            $usuario = $resultado->fetch_assoc();

            // 🔹 **Verificar si el usuario está inactivo**
            if (strtoupper($usuario["status"]) !== "ACTIVO") {
                echo json_encode(["status" => "error", "message" => "Usuario inactivo. Contacta al administrador."]);
                exit;
            }

            // 🔹 **Verificación segura de contraseña**
            if (password_verify($password, $usuario["password"])) {
                // 🔹 **Regenerar la sesión de manera segura**
                session_regenerate_id(true);
                $_SESSION["usuario_id"] = $usuario["usuario_id"];
                $_SESSION["nombre_completo"] = $usuario["nombre_completo"];
                $_SESSION["email"] = $usuario["email"];
                $_SESSION["promotoria"] = $usuario["promotoria_id"];
                $_SESSION['puesto'] = $usuario['puesto_id'];
                $_SESSION['rol_id'] = $usuario['rol_id'];

                // 🔹 **Redirigir según el rol**
                $redirectUrl = match ($usuario["rol_id"]) {
                    1 => $URL . "/src/app/view/dashboard/usuario-control-total/administrador-general.php",
                    2 => $URL . '/app/view/dashboard/empleado/dashboard.php',
                    3 => $URL . '/src/app/view/dashboard/panel-curso/panel-curso.php',
                    4 => $URL . '/app/view/dashboard/coordinador-general/dashboard.php',
                    default => $URL . '/public/index.php',
                };

                echo json_encode(["status" => "success", "message" => "Acceso correcto.", "redirect" => $redirectUrl]);
            } else {
                echo json_encode(["status" => "error", "message" => "Credenciales incorrectas."]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "Usuario no encontrado."]);
        }
    } catch (Exception $e) {
        echo json_encode(["status" => "error", "message" => "Error en el servidor."]);
    } finally {
        if ($stmt) {
            $stmt->close();
        }
        $conexion->close();
    }
}
