<?php
// require '../config/config.php';
// header('Content-Type: application/json');
// if ($conexion->connect_error) {
//     die("Error de conexión: " . $conexion->connect_error);
// }

// // // Obtener el ID del curso (¡Asegúrate de obtenerlo de forma segura!)
// $cursoID = $_GET['curso_id'] ?? 0; // Ejemplo: Obtenerlo de la URL

// // Consulta para obtener temario y preguntas
// $consulta = "SELECT
//         tc.ID_Titulo,
//         tt.nom_titulo_temario,
//         tc.cuestionario_id,
//         cu.titulo AS titulo_cuestionario,
//         p.pregunta_id,
//         p.texto_pregunta,
//         op.opcion_id,
//         op.texto_opcion AS opcion_respuesta,
//         op.es_correcta
//     FROM titulos_temarios_cuestionarios tc
//     LEFT JOIN titulos_temarios tt ON tt.ID_Titulo = tc.ID_Titulo
//     LEFT JOIN cuestionarios cu ON cu.cuestionario_id = tc.cuestionario_id
//     LEFT JOIN preguntas p ON p.cuestionario_id = cu.cuestionario_id
//     LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//     WHERE tt.curso_id = ?
//     ORDER BY tt.Orden, p.pregunta_id, op.opcion_id";

// $stmt = $conexion->prepare($consulta);

// if ($stmt === false) {
//     die("Error en la preparación de la consulta: " . $conexion->error);
// }

// $stmt->bind_param("i", $cursoID);
// $stmt->execute();
// $resultado = $stmt->get_result();

// // Organizar los datos
// $datos_curso = [];
// while ($fila = $resultado->fetch_assoc()) {
//     $titulo_id = $fila['ID_Titulo'];
//     $pregunta_id = $fila['pregunta_id'];
//     if (!isset($datos_curso[$titulo_id])) {
//         $datos_curso[$titulo_id] = [
//             'titulo' => $fila['nom_titulo_temario'],
//             'preguntas' => []
//         ];
//     }

//     if (!isset($datos_curso[$titulo_id]['preguntas'][$pregunta_id])) {
//         $datos_curso[$titulo_id]['preguntas'][$pregunta_id] = [
//             'texto_pregunta' => $fila['texto_pregunta'],
//             'opciones' => []
//         ];
//     }

//     $datos_curso[$titulo_id]['preguntas'][$pregunta_id]['opciones'][] = [
//         'opcion_id' => $fila['opcion_id'],
//         'texto_opcion' => $fila['opcion_respuesta'],
//         'es_correcta' => $fila['es_correcta']
//     ];
// }

// $stmt->close();
// $conexion->close();

// // Enviar la respuesta como JSON
// header('Content-Type: application/json');
// echo json_encode($datos_curso);
// Consulta para obtener temario y preguntas





// -- Primero obtener los temas del curso
// SELECT 
//     tt.ID_Titulo,
//     tt.nom_titulo_temario AS nombre_tema,
//     tt.Orden AS orden_tema,
//     c.curso_title AS nombre_curso,
//     COUNT(DISTINCT tc.cuestionario_id) AS cantidad_cuestionarios
// FROM 
//     titulos_temarios tt
// JOIN 
//     cursos c ON c.curso_id = tt.curso_id
// LEFT JOIN 
//     titulos_temarios_cuestionarios tc ON tc.ID_Titulo = tt.ID_Titulo
// WHERE 
//     tt.curso_id = 8
// GROUP BY 
//     tt.ID_Titulo, tt.nom_titulo_temario, tt.Orden, c.curso_title
// ORDER BY 
//     tt.Orden;




// $consulta = "SELECT
//         tc.ID_Titulo,
//         tt.nom_titulo_temario,
//         c.curso_title AS NOMBRE_CURSO,
//         tc.cuestionario_id,
//         cu.titulo AS titulo_cuestionario,
//         p.pregunta_id,
//         p.texto_pregunta,
//         op.opcion_id,
//         op.texto_opcion AS opcion_respuesta,
//         op.es_correcta
//     FROM titulos_temarios_cuestionarios tc
//     LEFT JOIN titulos_temarios tt ON tt.ID_Titulo = tc.ID_Titulo
//     LEFT JOIN cuestionarios cu ON cu.cuestionario_id = tc.cuestionario_id
//     LEFT JOIN preguntas p ON p.cuestionario_id = cu.cuestionario_id
//     LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//     LEFT JOIN cursos c ON c.curso_id = tt.curso_id
//     WHERE tt.curso_id = ?
//     ORDER BY tt.Orden, p.pregunta_id, op.opcion_id";

// $stmt = $conexion->prepare($consulta);

// if ($stmt === false) {
//     die("Error en la preparación de la consulta: " . $conexion->error);
// }

// $stmt->bind_param("i", $cursoID);
// $stmt->execute();
// $resultado = $stmt->get_result();

// // Organizar los datos
// $datos_curso = [];
// while ($fila = $resultado->fetch_assoc()) {
//     $titulo_id = $fila['ID_Titulo'];
//     $pregunta_id = $fila['pregunta_id'];

//     // Inicializar el tema si no existe
//     if (!isset($datos_curso[$titulo_id])) {
//         $datos_curso[$titulo_id] = [
//             'titulo' => $fila['nom_titulo_temario'],
//             'preguntas' => []
//         ];
//     }

//     // Inicializar la pregunta si no existe
//     if (!isset($datos_curso[$titulo_id]['preguntas'][$pregunta_id])) {
//         $datos_curso[$titulo_id]['preguntas'][$pregunta_id] = [
//             'texto_pregunta' => $fila['texto_pregunta'],
//             'opciones' => []
//         ];
//     }

//     // Agregar la opción de respuesta a la pregunta
//     $datos_curso[$titulo_id]['preguntas'][$pregunta_id]['opciones'][] = [
//         'opcion_id' => $fila['opcion_id'],
//         'texto_opcion' => $fila['opcion_respuesta'],
//         'es_correcta' => $fila['es_correcta']
//     ];
// }

// $stmt->close();
// $conexion->close();

// // Enviar la respuesta como JSON
// header('Content-Type: application/json');
// echo json_encode($datos_curso);




// // Consulta para obtener la estructura del temario
// $consultaTemario = "SELECT 
//         c.curso_id,
//         c.curso_title,
//         tt.ID_Titulo,
//         tt.nom_titulo_temario,
//         cot.id_Contenido,
//         cot.nombre_contenido,
//         cot.descripcion_contenido,
//         GROUP_CONCAT(DISTINCT mt.tipo_material SEPARATOR '|') AS tipos_materiales,
//         GROUP_CONCAT(DISTINCT mt.ruta_archivo SEPARATOR '|') AS rutas_materiales
//     FROM cursos c
//     LEFT JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
//     LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
//     LEFT JOIN materiales_contenido mt ON mt.id_Contenido = cot.id_Contenido
//     WHERE c.curso_id = ?
//     GROUP BY tt.ID_Titulo, tt.nom_titulo_temario, cot.id_Contenido, cot.nombre_contenido, cot.descripcion_contenido
//     ORDER BY tt.Orden, cot.Orden";

// $stmtTemario = $conexion->prepare($consultaTemario);
// $stmtTemario->bind_param("i", $cursoID);
// $stmtTemario->execute();
// $resultadoTemario = $stmtTemario->get_result();

// // Consulta para obtener todas las preguntas del curso
// $consultaPreguntas = "SELECT
//         cu.cuestionario_id,
//         cu.titulo AS titulo_cuestionario,
//         p.pregunta_id,
//         p.texto_pregunta,
//         op.opcion_id,
//         op.texto_opcion,
//         op.es_correcta
//     FROM cuestionarios cu
//     JOIN titulos_temarios_cuestionarios tc ON tc.cuestionario_id = cu.cuestionario_id
//     JOIN titulos_temarios tt ON tt.ID_Titulo = tc.ID_Titulo
//     JOIN preguntas p ON p.cuestionario_id = cu.cuestionario_id
//     LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//     WHERE tt.curso_id = ?
//     ORDER BY p.pregunta_id, op.opcion_id";

// $stmtPreguntas = $conexion->prepare($consultaPreguntas);
// $stmtPreguntas->bind_param("i", $cursoID);
// $stmtPreguntas->execute();
// $resultadoPreguntas = $stmtPreguntas->get_result();

// // Organizar los datos del temario
// $temario = [];
// $curso_title = ''; // Variable para almacenar el título del curso

// while ($fila = $resultadoTemario->fetch_assoc()) {
//     // Guardar el título del curso solo la primera vez
//     if (empty($curso_title)) {
//         $curso_title = $fila['curso_title'];
//     }

//     $titulo_id = $fila['ID_Titulo'];
//     $contenido_id = $fila['id_Contenido'];

//     if (!isset($temario[$titulo_id])) {
//         $temario[$titulo_id] = [
//             'titulo' => $fila['nom_titulo_temario'],
//             'contenidos' => []
//         ];
//     }

//     if ($contenido_id) {
//         $temario[$titulo_id]['contenidos'][] = [
//             'id' => $contenido_id,
//             'nombre' => $fila['nombre_contenido'],
//             'descripcion' => $fila['descripcion_contenido'],
//             'materiales' => [
//                 'tipos' => $fila['tipos_materiales'] ? explode('|', $fila['tipos_materiales']) : [],
//                 'rutas' => $fila['rutas_materiales'] ? explode('|', $fila['rutas_materiales']) : []
//             ]
//         ];
//     }
// }

// // Organizar las preguntas
// $preguntas = [];
// while ($fila = $resultadoPreguntas->fetch_assoc()) {
//     $pregunta_id = $fila['pregunta_id'];

//     if (!isset($preguntas[$pregunta_id])) {
//         $preguntas[$pregunta_id] = [
//             'texto' => $fila['texto_pregunta'],
//             'opciones' => []
//         ];
//     }

//     if ($fila['opcion_id']) {
//         $preguntas[$pregunta_id]['opciones'][] = [
//             'id' => $fila['opcion_id'],
//             'texto' => $fila['texto_opcion'],
//             'correcta' => (bool)$fila['es_correcta']
//         ];
//     }
// }

// // Preparar respuesta final
// $respuesta = [
//     'curso_id' => $cursoID,
//     'curso_title' => $curso_title, // Usamos la variable que guardamos antes
//     'temario' => array_values($temario),
//     'preguntas' => array_values($preguntas)
// ];

// // Cerrar conexiones
// $stmtTemario->close();
// $stmtPreguntas->close();
// $conexion->close();

// // Enviar respuesta como JSON
// header('Content-Type: application/json');
// echo json_encode($respuesta);


// Configuración de encabezados para JSON


/***********************************************************************************************************************************************************************************************/

// Consulta para obtener la estructura del temario
// $consultaTemario = "SELECT 
//         c.curso_id,
//         c.curso_title,
//         tt.ID_Titulo,
//         tt.nom_titulo_temario,
//         cot.id_Contenido,
//         cot.nombre_contenido,
//         cot.descripcion_contenido,
//         GROUP_CONCAT(DISTINCT mt.tipo_material SEPARATOR '|') AS tipos_materiales,
//         GROUP_CONCAT(DISTINCT mt.ruta_archivo SEPARATOR '|') AS rutas_materiales
//     FROM cursos c
//     LEFT JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
//     LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
//     LEFT JOIN materiales_contenido mt ON mt.id_Contenido = cot.id_Contenido
//     WHERE c.curso_id = ?
//     GROUP BY tt.ID_Titulo, tt.nom_titulo_temario, cot.id_Contenido, cot.nombre_contenido, cot.descripcion_contenido
//     ORDER BY tt.Orden, cot.Orden";

// $stmtTemario = $conexion->prepare($consultaTemario);
// if (!$stmtTemario) {
//     echo json_encode(['error' => 'Error al preparar consulta de temario: ' . $conexion->error]);
//     exit;
// }

// $stmtTemario->bind_param("i", $cursoID);
// if (!$stmtTemario->execute()) {
//     echo json_encode(['error' => 'Error al ejecutar consulta de temario: ' . $stmtTemario->error]);
//     exit;
// }

// $resultadoTemario = $stmtTemario->get_result();

// // Consulta para obtener todas las preguntas del curso
// $consultaPreguntas = "SELECT
//         cu.cuestionario_id,
//         cu.titulo AS titulo_cuestionario,
//         p.pregunta_id,
//         p.texto_pregunta,
//         op.opcion_id,
//         op.texto_opcion,
//         op.es_correcta
//     FROM cuestionarios cu
//     JOIN titulos_temarios_cuestionarios tc ON tc.cuestionario_id = cu.cuestionario_id
//     JOIN titulos_temarios tt ON tt.ID_Titulo = tc.ID_Titulo
//     JOIN preguntas p ON p.cuestionario_id = cu.cuestionario_id
//     LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//     WHERE tt.curso_id = ?
//     ORDER BY p.pregunta_id, op.opcion_id";

// $stmtPreguntas = $conexion->prepare($consultaPreguntas);
// if (!$stmtPreguntas) {
//     echo json_encode(['error' => 'Error al preparar consulta de preguntas: ' . $conexion->error]);
//     exit;
// }

// $stmtPreguntas->bind_param("i", $cursoID);
// if (!$stmtPreguntas->execute()) {
//     echo json_encode(['error' => 'Error al ejecutar consulta de preguntas: ' . $stmtPreguntas->error]);
//     exit;
// }

// $resultadoPreguntas = $stmtPreguntas->get_result();

// // Variables para almacenar los datos
// $curso_title = '';
// $temario = [];
// $preguntas = [];

// // Procesar el temario
// if ($resultadoTemario->num_rows > 0) {
//     while ($fila = $resultadoTemario->fetch_assoc()) {
//         // Guardar el título del curso solo la primera vez
//         if (empty($curso_title)) {
//             $curso_title = $fila['curso_title'];
//         }

//         $titulo_id = $fila['ID_Titulo'];
//         $contenido_id = $fila['id_Contenido'] ?? null;

//         if (!isset($temario[$titulo_id])) {
//             $temario[$titulo_id] = [
//                 'titulo' => $fila['nom_titulo_temario'],
//                 'contenidos' => []
//             ];
//         }

//         if ($contenido_id) {
//             $temario[$titulo_id]['contenidos'][] = [
//                 'id' => $contenido_id,
//                 'nombre' => $fila['nombre_contenido'] ?? '',
//                 'descripcion' => $fila['descripcion_contenido'] ?? '',
//                 'materiales' => [
//                     'tipos' => !empty($fila['tipos_materiales']) ? explode('|', $fila['tipos_materiales']) : [],
//                     'rutas' => !empty($fila['rutas_materiales']) ? explode('|', $fila['rutas_materiales']) : []
//                 ]
//             ];
//         }
//     }
// }

// // Procesar las preguntas
// if ($resultadoPreguntas->num_rows > 0) {
//     while ($fila = $resultadoPreguntas->fetch_assoc()) {
//         $pregunta_id = $fila['pregunta_id'];

//         if (!isset($preguntas[$pregunta_id])) {
//             $preguntas[$pregunta_id] = [
//                 'texto' => $fila['texto_pregunta'],
//                 'opciones' => []
//             ];
//         }

//         if ($fila['opcion_id']) {
//             $preguntas[$pregunta_id]['opciones'][] = [
//                 'id' => $fila['opcion_id'],
//                 'texto' => $fila['texto_opcion'],
//                 'correcta' => (bool)$fila['es_correcta']
//             ];
//         }
//     }
// }

// // Preparar respuesta final
// $respuesta = [
//     'success' => true,
//     'curso_id' => $cursoID,
//     'curso_title' => $curso_title,
//     'temario' => array_values($temario),
//     'preguntas' => array_values($preguntas)
// ];

// // Liberar recursos
// $stmtTemario->close();
// $stmtPreguntas->close();
// $conexion->close();

// // Enviar respuesta
// echo json_encode($respuesta);

/*************************************************************************************************************************************************** */



// // Consulta para obtener la estructura del temario con todos los materiales
// $consultaTemario = "SELECT 
//         c.curso_id,
//         c.curso_title,
//         tt.ID_Titulo,
//         tt.nom_titulo_temario,
//         tt.Orden AS orden_titulo,
//         cot.id_Contenido,
//         cot.nombre_contenido,
//         cot.descripcion_contenido,
//         cot.Orden AS orden_contenido,
//         GROUP_CONCAT(mt.tipo_material SEPARATOR '|||') AS tipos_materiales,
//         GROUP_CONCAT(mt.ruta_archivo SEPARATOR '|||') AS rutas_materiales,
//         GROUP_CONCAT(mt.id_material SEPARATOR '|||') AS ids_materiales
//     FROM cursos c
//     LEFT JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
//     LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
//     LEFT JOIN materiales_contenido mt ON mt.id_Contenido = cot.id_Contenido
//     WHERE c.curso_id = ?
//     GROUP BY 
//         c.curso_id,
//         c.curso_title,
//         tt.ID_Titulo,
//         tt.nom_titulo_temario,
//         tt.Orden,
//         cot.id_Contenido,
//         cot.nombre_contenido,
//         cot.descripcion_contenido,
//         cot.Orden
//     ORDER BY 
//         tt.Orden, 
//         cot.Orden,
//         mt.id_material";

// $stmtTemario = $conexion->prepare($consultaTemario);
// if (!$stmtTemario) {
//     echo json_encode(['error' => 'Error al preparar consulta de temario: ' . $conexion->error]);
//     exit;
// }

// $stmtTemario->bind_param("i", $cursoID);
// if (!$stmtTemario->execute()) {
//     echo json_encode(['error' => 'Error al ejecutar consulta de temario: ' . $stmtTemario->error]);
//     exit;
// }

// $resultadoTemario = $stmtTemario->get_result();

// // Consulta para obtener todas las preguntas del curso (se mantiene igual)
// $consultaPreguntas = "SELECT
//         cu.cuestionario_id,
//         cu.titulo AS titulo_cuestionario,
//         p.pregunta_id,
//         p.texto_pregunta,
//         op.opcion_id,
//         op.texto_opcion,
//         op.es_correcta
//     FROM cuestionarios cu
//     JOIN titulos_temarios_cuestionarios tc ON tc.cuestionario_id = cu.cuestionario_id
//     JOIN titulos_temarios tt ON tt.ID_Titulo = tc.ID_Titulo
//     JOIN preguntas p ON p.cuestionario_id = cu.cuestionario_id
//     LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//     WHERE tt.curso_id = ?
//     ORDER BY p.pregunta_id, op.opcion_id";

// $stmtPreguntas = $conexion->prepare($consultaPreguntas);
// if (!$stmtPreguntas) {
//     echo json_encode(['error' => 'Error al preparar consulta de preguntas: ' . $conexion->error]);
//     exit;
// }

// $stmtPreguntas->bind_param("i", $cursoID);
// if (!$stmtPreguntas->execute()) {
//     echo json_encode(['error' => 'Error al ejecutar consulta de preguntas: ' . $stmtPreguntas->error]);
//     exit;
// }

// $resultadoPreguntas = $stmtPreguntas->get_result();

// // Variables para almacenar los datos
// $curso_title = '';
// $temario = [];
// $preguntas = [];

// // Procesar el temario con la nueva estructura
// if ($resultadoTemario->num_rows > 0) {
//     while ($fila = $resultadoTemario->fetch_assoc()) {
//         // Guardar el título del curso solo la primera vez
//         if (empty($curso_title)) {
//             $curso_title = $fila['curso_title'];
//         }

//         $titulo_id = $fila['ID_Titulo'];
//         $contenido_id = $fila['id_Contenido'];

//         // Inicializar el tema si no existe
//         if (!isset($temario[$titulo_id])) {
//             $temario[$titulo_id] = [
//                 'titulo' => $fila['nom_titulo_temario'],
//                 'orden' => $fila['orden_titulo'],
//                 'contenidos' => []
//             ];
//         }

//         // Procesar materiales solo si hay contenido
//         $materiales = [];
//         if (!empty($fila['tipos_materiales'])) {
//             $tipos = explode('|||', $fila['tipos_materiales']);
//             $rutas = explode('|||', $fila['rutas_materiales']);
//             $ids = explode('|||', $fila['ids_materiales']);

//             for ($i = 0; $i < count($tipos); $i++) {
//                 if (!empty($tipos[$i])) {
//                     $materiales[] = [
//                         'id' => $ids[$i] ?? null,
//                         'tipo' => $tipos[$i],
//                         'ruta' => $rutas[$i] ?? ''
//                     ];
//                 }
//             }
//         }

//         // Agregar contenido al tema
//         $temario[$titulo_id]['contenidos'][] = [
//             'id' => $contenido_id,
//             'nombre' => $fila['nombre_contenido'] ?? '',
//             'descripcion' => $fila['descripcion_contenido'] ?? '',
//             'orden' => $fila['orden_contenido'],
//             'materiales' => $materiales
//         ];
//     }
// }

// // Procesar las preguntas (se mantiene igual)
// if ($resultadoPreguntas->num_rows > 0) {
//     while ($fila = $resultadoPreguntas->fetch_assoc()) {
//         $pregunta_id = $fila['pregunta_id'];

//         if (!isset($preguntas[$pregunta_id])) {
//             $preguntas[$pregunta_id] = [
//                 'texto' => $fila['texto_pregunta'],
//                 'opciones' => []
//             ];
//         }

//         if ($fila['opcion_id']) {
//             $preguntas[$pregunta_id]['opciones'][] = [
//                 'id' => $fila['opcion_id'],
//                 'texto' => $fila['texto_opcion'],
//                 'correcta' => (bool)$fila['es_correcta']
//             ];
//         }
//     }
// }

// // Ordenar el temario por el campo 'orden'
// usort($temario, function ($a, $b) {
//     return $a['orden'] <=> $b['orden'];
// });

// // Ordenar contenidos dentro de cada tema
// foreach ($temario as &$tema) {
//     usort($tema['contenidos'], function ($a, $b) {
//         return $a['orden'] <=> $b['orden'];
//     });
// }

// // Preparar respuesta final
// $respuesta = [
//     'success' => true,
//     'curso_id' => $cursoID,
//     'curso_title' => $curso_title,
//     'temario' => array_values($temario),
//     'preguntas' => array_values($preguntas)
// ];

// // Liberar recursos
// $stmtTemario->close();
// $stmtPreguntas->close();
// $conexion->close();

// // Enviar respuesta
// echo json_encode($respuesta, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);




header('Content-Type: application/json');
require '../config/config.php';

$response = [
    'success' => false,
    'error' => '',
    'curso_id' => 0,
    'curso_title' => '',
    'temario' => [],
    'preguntas' => []
];

try {
    // Validar curso_id
    $cursoID = isset($_GET['curso_id']) ? (int)$_GET['curso_id'] : 0;
    if ($cursoID <= 0) {
        throw new Exception("ID de curso no válido");
    }
    $response['curso_id'] = $cursoID;

    if ($conexion->connect_error) {
        throw new Exception("Error de conexión: " . $conexion->connect_error);
    }

    // 1. Consulta para obtener la estructura del temario (se mantiene igual)
    $consultaTemario = "SELECT 
            c.curso_id,
            c.curso_title,
            tt.ID_Titulo,
            tt.nom_titulo_temario,
            tt.Orden AS orden_titulo,
            cot.id_Contenido,
            cot.nombre_contenido,
            cot.descripcion_contenido,
            cot.Orden AS orden_contenido,
            GROUP_CONCAT(mt.tipo_material SEPARATOR '|') AS tipos_materiales,
            GROUP_CONCAT(mt.ruta_archivo SEPARATOR '|') AS rutas_materiales,
            GROUP_CONCAT(mt.id_material SEPARATOR '|') AS ids_materiales
        FROM cursos c
        LEFT JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
        LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
        LEFT JOIN materiales_contenido mt ON mt.id_Contenido = cot.id_Contenido
        WHERE c.curso_id = ?
        GROUP BY 
            c.curso_id,
            c.curso_title,
            tt.ID_Titulo,
            tt.nom_titulo_temario,
            tt.Orden,
            cot.id_Contenido,
            cot.nombre_contenido,
            cot.descripcion_contenido,
            cot.Orden
        ORDER BY 
            tt.Orden, 
            cot.Orden";

    $stmtTemario = $conexion->prepare($consultaTemario);
    if (!$stmtTemario) {
        throw new Exception('Error al preparar consulta de temario: ' . $conexion->error);
    }

    $stmtTemario->bind_param("i", $cursoID);
    if (!$stmtTemario->execute()) {
        throw new Exception('Error al ejecutar consulta de temario: ' . $stmtTemario->error);
    }

    $resultadoTemario = $stmtTemario->get_result();

    // 2. Consulta optimizada para preguntas (versión mejorada)
    $consultaPreguntas = "SELECT
            p.pregunta_id,
            p.texto_pregunta,
            p.puntaje,
            op.opcion_id,
            op.texto_opcion,
            op.es_correcta,
            c.cuestionario_id,
            c.titulo AS titulo_cuestionario
        FROM titulos_temarios tt
        JOIN titulos_temarios_cuestionarios ttc ON ttc.ID_Titulo = tt.ID_Titulo
        JOIN cuestionarios c ON c.cuestionario_id = ttc.cuestionario_id
        JOIN preguntas p ON p.cuestionario_id = c.cuestionario_id
        LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
        WHERE tt.curso_id = ?
        GROUP BY p.pregunta_id, op.opcion_id
        ORDER BY p.pregunta_id, op.opcion_id";

    $stmtPreguntas = $conexion->prepare($consultaPreguntas);
    if (!$stmtPreguntas) {
        throw new Exception('Error al preparar consulta de preguntas: ' . $conexion->error);
    }

    $stmtPreguntas->bind_param("i", $cursoID);
    if (!$stmtPreguntas->execute()) {
        throw new Exception('Error al ejecutar consulta de preguntas: ' . $stmtPreguntas->error);
    }

    $resultadoPreguntas = $stmtPreguntas->get_result();

    // Procesar el temario (se mantiene igual)
    $temario = [];
if ($resultadoTemario->num_rows > 0) {
    while ($fila = $resultadoTemario->fetch_assoc()) {
        if (empty($response['curso_title'])) {
            $response['curso_title'] = $fila['curso_title'];
        }

        $titulo_id = $fila['ID_Titulo'];
        $contenido_id = $fila['id_Contenido'];

        // Inicialización de estructura de título si no existe
        if (!isset($temario[$titulo_id])) {
            $temario[$titulo_id] = [
                'titulo' => htmlspecialchars($fila['nom_titulo_temario']),
                'orden' => (int)$fila['orden_titulo'],
                'contenidos' => []
            ];
        }

        // Procesamiento de materiales más robusto
        $materiales = [];
        if (!empty($fila['tipos_materiales']) && !empty($fila['rutas_materiales'])) {
            // Usar el mismo separador que en GROUP_CONCAT
            $tipos = explode('|', $fila['tipos_materiales']);
            $rutas = explode('|', $fila['rutas_materiales']);
            $ids = !empty($fila['ids_materiales']) ? explode('|', $fila['ids_materiales']) : [];

            // Asegurar que todos los arrays tengan la misma longitud
            $maxItems = min(count($tipos), count($rutas), !empty($ids) ? count($ids) : PHP_INT_MAX);
            
            for ($i = 0; $i < $maxItems; $i++) {
                $tipo = strtolower(trim($tipos[$i]));
                $ruta = trim($rutas[$i]);
                
                // Determinar tipo real por extensión si es necesario
                $extension = pathinfo($ruta, PATHINFO_EXTENSION);
                $tipoFinal = $tipo;
                
                if (empty($tipo)) {
                    if (in_array($extension, ['mp4', 'webm', 'ogg', 'mov'])) {
                        $tipoFinal = 'video';
                    } elseif ($extension === 'pdf') {
                        $tipoFinal = 'pdf';
                    }
                }

                // Validar rutas
                if (!empty($ruta)) {
                    $materiales[] = [
                        'id' => $ids[$i] ?? null,
                        'tipo' => $tipoFinal,
                        'ruta' => $ruta,
                        'nombre' => basename($ruta) // Añadir nombre basado en la ruta
                    ];
                }
            }
        }

        // Añadir contenido con validación
        $temario[$titulo_id]['contenidos'][] = [
            'id' => (int)$contenido_id,
            'nombre' => htmlspecialchars($fila['nombre_contenido'] ?? ''),
            'descripcion' => htmlspecialchars($fila['descripcion_contenido'] ?? ''),
            'orden' => (int)$fila['orden_contenido'],
            'materiales' => $materiales
        ];
    }
}

// Depuración (quitar en producción)
// error_log(print_r($temario, true));

    // Procesar preguntas (versión mejorada)
    $preguntas = [];
    $cuestionarios = [];

    if ($resultadoPreguntas->num_rows > 0) {
        while ($fila = $resultadoPreguntas->fetch_assoc()) {
            $pregunta_id = $fila['pregunta_id'];
            $cuestionario_id = $fila['cuestionario_id'];

            // Registrar cuestionario si no existe
            if (!isset($cuestionarios[$cuestionario_id])) {
                $cuestionarios[$cuestionario_id] = [
                    'id' => $cuestionario_id,
                    'titulo' => $fila['titulo_cuestionario']
                ];
            }

            // Crear pregunta si no existe
            if (!isset($preguntas[$pregunta_id])) {
                $preguntas[$pregunta_id] = [
                    'texto' => $fila['texto_pregunta'],
                    'puntaje' => $fila['puntaje'] ?? 1, // Valor por defecto
                    'opciones' => []
                ];
            }

            // Agregar opción si existe
            if ($fila['opcion_id']) {
                $preguntas[$pregunta_id]['opciones'][] = [
                    'id' => $fila['opcion_id'],
                    'texto' => $fila['texto_opcion'],
                    'correcta' => (bool)$fila['es_correcta']
                ];
            }
        }
    }

    // Ordenar el temario
    usort($temario, function ($a, $b) {
        return $a['orden'] <=> $b['orden'];
    });

    foreach ($temario as &$tema) {
        usort($tema['contenidos'], function ($a, $b) {
            return $a['orden'] <=> $b['orden'];
        });
    }

    // Preparar respuesta final
    $response['success'] = true;
    $response['temario'] = array_values($temario);
    $response['preguntas'] = array_values($preguntas);
    $response['cuestionarios'] = array_values($cuestionarios); // Nuevo campo opcional

} catch (Exception $e) {
    $response['error'] = $e->getMessage();
    http_response_code(500);
} finally {
    // Cerrar conexiones si existen
    if (isset($stmtTemario) && $stmtTemario) $stmtTemario->close();
    if (isset($stmtPreguntas) && $stmtPreguntas) $stmtPreguntas->close();
    if (isset($conexion) && $conexion) $conexion->close();
}

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);