<?php
// header('Content-Type: application/json');
// require '../config/config.php';

// $response = [
//     "success" => false,
//     "data" => [],
//     "error" => ""
// ];

// try {


//     if ($conexion->connect_error) {
//         throw new Exception("Error de conexión: " . $conexion->connect_error);
//     }

//     $query = "
//         SELECT 
//             c.curso_id,
//             c.curso_title AS nombre_curso,
//             tt.ID_Titulo,
//             tt.nom_titulo_temario AS nombre_titulo_temario,
//             q.cuestionario_id,
//             q.titulo AS nombre_cuestionario,
//             GROUP_CONCAT(
//                 DISTINCT p.pregunta_id 
//                 ORDER BY p.pregunta_id
//                 SEPARATOR '|'
//             ) AS ids_preguntas,
//             GROUP_CONCAT(
//                 DISTINCT CONCAT(
//                     p.pregunta_id, '~', 
//                     p.texto_pregunta, '~', 
//                     p.puntaje
//                 )
//                 ORDER BY p.pregunta_id
//                 SEPARATOR '||'
//             ) AS preguntas,
//             GROUP_CONCAT(
//                 CONCAT(
//                     p.pregunta_id, '^',
//                     op.opcion_id, '^',
//                     op.texto_opcion, '^',
//                     op.es_correcta, '^',
//                     p.puntaje
//                 )
//                 ORDER BY p.pregunta_id, op.opcion_id
//                 SEPARATOR '|'
//             ) AS opciones
//         FROM titulos_temarios_cuestionarios ttc
//         JOIN titulos_temarios tt ON tt.ID_Titulo = ttc.ID_Titulo
//         JOIN cuestionarios q ON q.cuestionario_id = ttc.cuestionario_id
//         JOIN preguntas p ON p.cuestionario_id = q.cuestionario_id
//         LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//         JOIN cursos c ON c.curso_id = tt.curso_id
//         GROUP BY c.curso_id, c.curso_title, tt.ID_Titulo, tt.nom_titulo_temario, q.cuestionario_id, q.titulo
//         ORDER BY tt.ID_Titulo, q.cuestionario_id
//     ";

//     $stmt = $conexion->prepare($query);
//     $stmt->execute();
//     $result = $stmt->get_result();

//     $data = [];
//     while ($row = $result->fetch_assoc()) {
//         // Procesar preguntas
//         $preguntasRaw = explode('||', $row['preguntas']);
//         $preguntas = [];

//         foreach ($preguntasRaw as $preguntaStr) {
//             $parts = explode('~', $preguntaStr);
//             if (count($parts) === 3) {
//                 $preguntas[$parts[0]] = [
//                     'id' => $parts[0],
//                     'texto' => $parts[1],
//                     'puntaje' => $parts[2]
//                 ];
//             }
//         }

//         // Procesar opciones
//         $opcionesRaw = explode('|', $row['opciones']);
//         $opciones = [];

//         foreach ($opcionesRaw as $opcionStr) {
//             $parts = explode('^', $opcionStr);
//             if (count($parts) === 5) {
//                 $preguntaId = $parts[0];
//                 if (!isset($opciones[$preguntaId])) {
//                     $opciones[$preguntaId] = [];
//                 }

//                 $opciones[$preguntaId][] = [
//                     'id' => $parts[1],
//                     'texto' => $parts[2],
//                     'es_correcta' => (bool)$parts[3],
//                     'puntaje' => $parts[4]
//                 ];
//             }
//         }

//         // Combinar preguntas con sus opciones
//         $preguntasCompletas = [];
//         foreach ($preguntas as $preguntaId => $pregunta) {
//             $preguntasCompletas[] = [
//                 'id' => $pregunta['id'],
//                 'texto' => $pregunta['texto'],
//                 'puntaje' => $pregunta['puntaje'],
//                 'opciones' => $opciones[$preguntaId] ?? []
//             ];
//         }

//         $data[] = [
//             'curso' => [
//                 'id' => $row['curso_id'],
//                 'nombre' => $row['nombre_curso']
//             ],
//             'titulo_temario' => [
//                 'id' => $row['ID_Titulo'],
//                 'nombre' => $row['nombre_titulo_temario']
//             ],
//             'cuestionario' => [
//                 'id' => $row['cuestionario_id'],
//                 'nombre' => $row['nombre_cuestionario']
//             ],
//             'preguntas' => $preguntasCompletas
//         ];
//     }

//     $stmt->close();
//     $conexion->close();

//     $response["success"] = true;
//     $response["data"] = $data;
// } catch (Exception $e) {
//     $response["error"] = $e->getMessage();
// }

// echo json_encode($response);


/***************************************************************EL BUENO |||||||********************************* */

header('Content-Type: application/json');
require '../config/config.php';

$response = [
    "success" => false,
    "data" => [],
    "error" => ""
];

try {
    if ($conexion->connect_error) {
        throw new Exception("Error de conexión: " . $conexion->connect_error);
    }

    // Consulta optimizada para evitar duplicados
    $query = "
        SELECT 
            c.curso_id,
            c.curso_title AS nombre_curso,
            tt.ID_Titulo,
            tt.nom_titulo_temario AS nombre_titulo_temario,
            q.cuestionario_id,
            q.titulo AS nombre_cuestionario,
            GROUP_CONCAT(
                DISTINCT p.pregunta_id 
                ORDER BY p.pregunta_id
                SEPARATOR '|'
            ) AS ids_preguntas,
            GROUP_CONCAT(
                DISTINCT CONCAT(
                    p.pregunta_id, '~', 
                    p.texto_pregunta, '~', 
                    p.puntaje
                )
                ORDER BY p.pregunta_id
                SEPARATOR '||'
            ) AS preguntas,
            GROUP_CONCAT(
                DISTINCT CONCAT(  -- Añadido DISTINCT aquí
                    p.pregunta_id, '^',
                    op.opcion_id, '^',
                    op.texto_opcion, '^',
                    op.es_correcta, '^',
                    p.puntaje
                )
                ORDER BY p.pregunta_id, op.opcion_id
                SEPARATOR '|'
            ) AS opciones
        FROM titulos_temarios_cuestionarios ttc
        JOIN titulos_temarios tt ON tt.ID_Titulo = ttc.ID_Titulo
        JOIN cuestionarios q ON q.cuestionario_id = ttc.cuestionario_id
        JOIN preguntas p ON p.cuestionario_id = q.cuestionario_id
        LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
        JOIN cursos c ON c.curso_id = tt.curso_id
        GROUP BY c.curso_id, c.curso_title, tt.ID_Titulo, tt.nom_titulo_temario, q.cuestionario_id, q.titulo
        ORDER BY tt.ID_Titulo, q.cuestionario_id
    ";

    $stmt = $conexion->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();

    $data = [];
    while ($row = $result->fetch_assoc()) {
        // Procesar preguntas (igual que antes)
        $preguntasRaw = explode('||', $row['preguntas']);
        $preguntas = [];

        foreach ($preguntasRaw as $preguntaStr) {
            $parts = explode('~', $preguntaStr);
            if (count($parts) === 3) {
                $preguntas[$parts[0]] = [
                    'id' => $parts[0],
                    'texto' => $parts[1],
                    'puntaje' => $parts[2]
                ];
            }
        }

        // Procesar opciones con verificación de duplicados
        $opcionesRaw = explode('|', $row['opciones']);
        $opciones = [];
        $opcionesUnicas = []; // Para controlar duplicados

        foreach ($opcionesRaw as $opcionStr) {
            $parts = explode('^', $opcionStr);
            if (count($parts) === 5) {
                $preguntaId = $parts[0];
                $opcionId = $parts[1];

                // Clave única para identificar opciones duplicadas
                $claveUnica = $preguntaId . '-' . $opcionId;

                if (!isset($opcionesUnicas[$claveUnica])) {
                    if (!isset($opciones[$preguntaId])) {
                        $opciones[$preguntaId] = [];
                    }

                    $opciones[$preguntaId][] = [
                        'id' => $opcionId,
                        'texto' => $parts[2],
                        'es_correcta' => (bool)$parts[3],
                        'puntaje' => $parts[4]
                    ];

                    $opcionesUnicas[$claveUnica] = true;
                }
            }
        }

        // Combinar preguntas con sus opciones (igual que antes)
        $preguntasCompletas = [];
        foreach ($preguntas as $preguntaId => $pregunta) {
            $preguntasCompletas[] = [
                'id' => $pregunta['id'],
                'texto' => $pregunta['texto'], // Corregí 'texto' (tenías 'texto')
                'puntaje' => $pregunta['puntaje'],
                'opciones' => $opciones[$preguntaId] ?? []
            ];
        }

        $data[] = [
            'curso' => [
                'id' => $row['curso_id'],
                'nombre' => $row['nombre_curso']
            ],
            'titulo_temario' => [
                'id' => $row['ID_Titulo'],
                'nombre' => $row['nombre_titulo_temario']
            ],
            'cuestionario' => [
                'id' => $row['cuestionario_id'],
                'nombre' => $row['nombre_cuestionario']
            ],
            'preguntas' => $preguntasCompletas
        ];
    }

    $stmt->close();
    $conexion->close();

    $response["success"] = true;
    $response["data"] = $data;
} catch (Exception $e) {
    $response["error"] = $e->getMessage();
}

echo json_encode($response);









/*********************************************************************************************************************************** */

// header('Content-Type: application/json');
// require '../config/config.php';

// $response = [
//     "success" => false,
//     "data" => [],
//     "error" => ""
// ];

// try {
//     if ($conexion->connect_error) {
//         throw new Exception("Error de conexión: " . $conexion->connect_error);
//     }

//     // Nueva consulta SQL sin GROUP_CONCAT, obteniendo los datos planos
//     $query = "
//         SELECT 
//             c.curso_id,
//             c.curso_title AS nombre_curso,
//             tt.ID_Titulo,
//             tt.nom_titulo_temario AS nombre_titulo_temario,
//             q.cuestionario_id,
//             q.titulo AS nombre_cuestionario,
//             p.pregunta_id,
//             p.texto_pregunta,
//             p.puntaje,
//             op.opcion_id,
//             op.texto_opcion,
//             op.es_correcta
//         FROM titulos_temarios_cuestionarios ttc
//         JOIN titulos_temarios tt ON tt.ID_Titulo = ttc.ID_Titulo
//         JOIN cuestionarios q ON q.cuestionario_id = ttc.cuestionario_id
//         JOIN preguntas p ON p.cuestionario_id = q.cuestionario_id
//         LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//         JOIN cursos c ON c.curso_id = tt.curso_id
//         ORDER BY c.curso_id, tt.ID_Titulo, q.cuestionario_id, p.pregunta_id, op.opcion_id
//     ";

//     $stmt = $conexion->prepare($query);
//     $stmt->execute();
//     $result = $stmt->get_result();

//     $data = [];
//     $cuestionarios = [];

//     // Procesamiento de los resultados
//     while ($row = $result->fetch_assoc()) {
//         $cursoId = $row['curso_id'];
//         $tituloId = $row['ID_Titulo'];
//         $cuestionarioId = $row['cuestionario_id'];
//         $preguntaId = $row['pregunta_id'];

//         if (!isset($cuestionarios[$cursoId])) {
//             $cuestionarios[$cursoId] = [
//                 'curso' => [
//                     'id' => $cursoId,
//                     'nombre' => $row['nombre_curso']
//                 ],
//                 'titulos_temarios' => []
//             ];
//         }

//         if (!isset($cuestionarios[$cursoId]['titulos_temarios'][$tituloId])) {
//             $cuestionarios[$cursoId]['titulos_temarios'][$tituloId] = [
//                 'id' => $tituloId,
//                 'nombre' => $row['nombre_titulo_temario'],
//                 'cuestionarios' => []
//             ];
//         }

//         if (!isset($cuestionarios[$cursoId]['titulos_temarios'][$tituloId]['cuestionarios'][$cuestionarioId])) {
//             $cuestionarios[$cursoId]['titulos_temarios'][$tituloId]['cuestionarios'][$cuestionarioId] = [
//                 'id' => $cuestionarioId,
//                 'nombre' => $row['nombre_cuestionario'],
//                 'preguntas' => []
//             ];
//         }

//         if (!isset($cuestionarios[$cursoId]['titulos_temarios'][$tituloId]['cuestionarios'][$cuestionarioId]['preguntas'][$preguntaId])) {
//             $cuestionarios[$cursoId]['titulos_temarios'][$tituloId]['cuestionarios'][$cuestionarioId]['preguntas'][$preguntaId] = [
//                 'id' => $preguntaId,
//                 'texto' => $row['texto_pregunta'],
//                 'puntaje' => $row['puntaje'],
//                 'opciones' => []
//             ];
//         }

//         if (!empty($row['opcion_id'])) {
//             $cuestionarios[$cursoId]['titulos_temarios'][$tituloId]['cuestionarios'][$cuestionarioId]['preguntas'][$preguntaId]['opciones'][] = [
//                 'id' => $row['opcion_id'],
//                 'texto' => $row['texto_opcion'],
//                 'es_correcta' => (bool)$row['es_correcta']
//             ];
//         }
//     }

//     // Reconvertir las claves para evitar claves asociativas (que puedan dar problemas al enviar JSON)
//     foreach ($cuestionarios as $curso) {
//         $curso['titulos_temarios'] = array_values($curso['titulos_temarios']);
//         foreach ($curso['titulos_temarios'] as &$titulo) {
//             $titulo['cuestionarios'] = array_values($titulo['cuestionarios']);
//             foreach ($titulo['cuestionarios'] as &$cuestionario) {
//                 $cuestionario['preguntas'] = array_values($cuestionario['preguntas']);
//             }
//         }
//         $data[] = $curso;
//     }

//     $stmt->close();
//     $conexion->close();

//     // Si llegamos aquí, significa que la consulta fue exitosa
//     $response["success"] = true;
//     $response["data"] = $data;
// } catch (Exception $e) {
//     // Si ocurre un error, mostramos el mensaje
//     $response["error"] = $e->getMessage();
// }

// // Devolvemos el JSON
// echo json_encode($response);















/********************************************************************************* */




// header('Content-Type: application/json');
// require '../config/config.php';

// $response = [
//     "success" => false,
//     "curso_title" => "",
//     "temario" => [],
//     "error" => ""
// ];

// try {
//     if ($conexion->connect_error) {
//         throw new Exception("Error de conexión: " . $conexion->connect_error);
//     }

//     $query = "
// SELECT
// c.curso_id,
// c.curso_title AS nombre_curso,
// tt.ID_Titulo,
// tt.nom_titulo_temario AS nombre_titulo_temario,
// q.cuestionario_id,
// q.titulo AS nombre_cuestionario,
// p.pregunta_id,
// p.texto_pregunta,
// p.puntaje AS puntaje_pregunta,
// op.opcion_id,
// op.texto_opcion,
// op.es_correcta,
// op.puntaje AS puntaje_opcion
// FROM titulos_temarios_cuestionarios ttc
// JOIN titulos_temarios tt ON tt.ID_Titulo = ttc.ID_Titulo
// JOIN cuestionarios q ON q.cuestionario_id = ttc.cuestionario_id
// JOIN preguntas p ON p.cuestionario_id = q.cuestionario_id
// LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
// JOIN cursos c ON c.curso_id = tt.curso_id
// ORDER BY tt.ID_Titulo, q.cuestionario_id, p.pregunta_id, op.opcion_id
// ";

//     $stmt = $conexion->prepare($query);
//     $stmt->execute();
//     $result = $stmt->get_result();

//     $estructura = [];
//     $cursoTitulo = "";

//     while ($row = $result->fetch_assoc()) {
//         $cursoTitulo = $row['nombre_curso'];

//         $temarioId = $row['ID_Titulo'];
//         $cuestionarioId = $row['cuestionario_id'];
//         $preguntaId = $row['pregunta_id'];
//         $opcionId = $row['opcion_id'];

//         // Inicializar el temario si no existe
//         if (!isset($estructura[$temarioId])) {
//             $estructura[$temarioId] = [
//                 "id" => $temarioId,
//                 "nombre" => $row['nombre_titulo_temario'],
//                 "cuestionarios" => []
//             ];
//         }

//         // Inicializar el cuestionario si no existe
//         if (!isset($estructura[$temarioId]["cuestionarios"][$cuestionarioId])) {
//             $estructura[$temarioId]["cuestionarios"][$cuestionarioId] = [
//                 "id" => $cuestionarioId,
//                 "nombre" => $row['nombre_cuestionario'],
//                 "preguntas" => []
//             ];
//         }

//         // Inicializar la pregunta si no existe
//         if (!isset($estructura[$temarioId]["cuestionarios"][$cuestionarioId]["preguntas"][$preguntaId])) {
//             $estructura[$temarioId]["cuestionarios"][$cuestionarioId]["preguntas"][$preguntaId] = [
//                 "id" => $preguntaId,
//                 "texto" => $row['texto_pregunta'],
//                 "puntaje" => $row['puntaje_pregunta'],
//                 "opciones" => []
//             ];
//         }

//         // Agregar opción si existe
//         if (!empty($opcionId)) {
//             $estructura[$temarioId]["cuestionarios"][$cuestionarioId]["preguntas"][$preguntaId]["opciones"][] = [
//                 "id" => $opcionId,
//                 "texto" => $row['texto_opcion'],
//                 "es_correcta" => (bool)$row['es_correcta'],
//                 "puntaje" => $row['puntaje_opcion']
//             ];
//         }
//     }

//     // Convertir estructura en arrays numerados para JSON limpio
//     $temarios = [];
//     foreach ($estructura as $temario) {
//         $cuestionarios = [];
//         foreach ($temario['cuestionarios'] as $cuest) {
//             $preguntas = [];
//             foreach ($cuest['preguntas'] as $preg) {
//                 $preguntas[] = $preg;
//             }
//             $cuest['preguntas'] = $preguntas;
//             $cuestionarios[] = $cuest;
//         }
//         $temario['cuestionarios'] = $cuestionarios;
//         $temarios[] = $temario;
//     }

//     $stmt->close();
//     $conexion->close();

//     $response["success"] = true;
//     $response["curso_title"] = $cursoTitulo;
//     $response["temario"] = $temarios;
// } catch (Exception $e) {
//     $response["error"] = $e->getMessage();
// }

// echo json_encode($response);



// header('Content-Type: application/json');
// require '../config/config.php';

// $response = [
//     "success" => false,
//     "data" => [],
//     "error" => "",
//     "temario" => [],
//     "curso_title" => "",
//     "preguntas" => []
// ];

// try {
//     if ($conexion->connect_error) {
//         throw new Exception("Error de conexión: " . $conexion->connect_error);
//     }

//     // Obtener parámetro curso_id
//     $cursoId = isset($_GET['curso_id']) ? intval($_GET['curso_id']) : 0;
//     if ($cursoId <= 0) {
//         throw new Exception("ID de curso no válido");
//     }

//     // 1. Primero obtenemos la estructura básica del curso y temario
//     $queryEstructura = "
//         SELECT 
//             c.curso_id,
//             c.curso_title,
//             tt.ID_Titulo,
//             tt.nom_titulo_temario,
//             ttc.cuestionario_id,
//             q.titulo AS nombre_cuestionario
//         FROM cursos c
//         JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
//         LEFT JOIN titulos_temarios_cuestionarios ttc ON ttc.ID_Titulo = tt.ID_Titulo
//         LEFT JOIN cuestionarios q ON q.cuestionario_id = ttc.cuestionario_id
//         WHERE c.curso_id = ?
//         ORDER BY tt.orden, q.orden
//     ";

//     $stmtEstructura = $conexion->prepare($queryEstructura);
//     $stmtEstructura->bind_param("i", $cursoId);
//     $stmtEstructura->execute();
//     $resultEstructura = $stmtEstructura->get_result();

//     $temario = [];
//     $cuestionariosIds = [];
//     $response['curso_title'] = '';

//     while ($row = $resultEstructura->fetch_assoc()) {
//         if (empty($response['curso_title'])) {
//             $response['curso_title'] = $row['curso_title'];
//         }

//         // Agrupar por temas/títulos
//         $tituloId = $row['ID_Titulo'];
//         if (!isset($temario[$tituloId])) {
//             $temario[$tituloId] = [
//                 'ID_Titulo' => $tituloId,
//                 'nom_titulo_temario' => $row['nom_titulo_temario'],
//                 'contenidos' => []
//             ];
//         }

//         // Agregar cuestionarios si existen
//         if ($row['cuestionario_id']) {
//             $temario[$tituloId]['contenidos'][] = [
//                 'tipo' => 'cuestionario',
//                 'id' => $row['cuestionario_id'],
//                 'nombre' => $row['nombre_cuestionario']
//             ];
//             $cuestionariosIds[] = $row['cuestionario_id'];
//         }
//     }
//     $stmtEstructura->close();

//     // Convertir a array indexado
//     $response['temario'] = array_values($temario);

//     // 2. Obtener todas las preguntas y opciones de los cuestionarios en una sola consulta optimizada
//     if (!empty($cuestionariosIds)) {
//         $placeholders = implode(',', array_fill(0, count($cuestionariosIds), '?'));

//         $queryPreguntas = "
//             SELECT 
//                 p.cuestionario_id,
//                 p.pregunta_id,
//                 p.texto_pregunta AS texto,
//                 p.puntaje,
//                 op.opcion_id,
//                 op.texto_opcion,
//                 op.es_correcta
//             FROM preguntas p
//             LEFT JOIN opciones_pregunta op ON op.pregunta_id = p.pregunta_id
//             WHERE p.cuestionario_id IN ($placeholders)
//             ORDER BY p.cuestionario_id, p.orden, op.orden
//         ";

//         $stmtPreguntas = $conexion->prepare($queryPreguntas);

//         // Vincular parámetros dinámicamente
//         $types = str_repeat('i', count($cuestionariosIds));
//         $stmtPreguntas->bind_param($types, ...$cuestionariosIds);

//         $stmtPreguntas->execute();
//         $resultPreguntas = $stmtPreguntas->get_result();

//         $preguntasPorCuestionario = [];

//         while ($row = $resultPreguntas->fetch_assoc()) {
//             $cuestionarioId = $row['cuestionario_id'];
//             $preguntaId = $row['pregunta_id'];

//             if (!isset($preguntasPorCuestionario[$cuestionarioId])) {
//                 $preguntasPorCuestionario[$cuestionarioId] = [];
//             }

//             if (!isset($preguntasPorCuestionario[$cuestionarioId][$preguntaId])) {
//                 $preguntasPorCuestionario[$cuestionarioId][$preguntaId] = [
//                     'texto' => $row['texto'],
//                     'puntaje' => $row['puntaje'],
//                     'opciones' => []
//                 ];
//             }

//             if ($row['opcion_id']) {
//                 $preguntasPorCuestionario[$cuestionarioId][$preguntaId]['opciones'][] = [
//                     'id' => $row['opcion_id'],
//                     'texto' => $row['texto_opcion'],
//                     'correcta' => (bool)$row['es_correcta']
//                 ];
//             }
//         }
//         $stmtPreguntas->close();

//         // Formatear preguntas para el frontend
//         foreach ($preguntasPorCuestionario as $cuestionarioId => $preguntas) {
//             $response['preguntas'] = array_merge(
//                 $response['preguntas'],
//                 array_values($preguntas)
//             );
//         }
//     }

//     $response["success"] = true;
// } catch (Exception $e) {
//     $response["error"] = $e->getMessage();
//     http_response_code(500);
// } finally {
//     if (isset($conexion) && $conexion) {
//         $conexion->close();
//     }
// }

// echo json_encode($response);