<?php
header('Content-Type: application/json');
require '../config/config.php';

$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 0,
    "recordsTotal" => 0,
    "recordsFiltered" => 0,
    "data" => [],
    "error" => ""
];

try {
    $start  = isset($_GET['start']) ? intval($_GET['start']) : 0;
    $length = isset($_GET['length']) ? intval($_GET['length']) : 10;
    $search = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

    if ($conexion->connect_error) {
        throw new Exception("Error de conexión: " . $conexion->connect_error);
    }

    $baseQuery = "
        FROM usuarios u 
        LEFT JOIN promotorias p ON p.promotoria_id = u.promotoria_id 
        LEFT JOIN puestos pu ON pu.puesto_id = u.puesto_id 
        LEFT JOIN roles r ON r.rol_id = u.rol_id
    ";

    // Total sin filtros
    $stmtTotal = $conexion->prepare("SELECT COUNT(*) AS total $baseQuery");
    $stmtTotal->execute();
    $totalResult = $stmtTotal->get_result()->fetch_assoc();
    $response['recordsTotal'] = intval($totalResult['total']);
    $stmtTotal->close();

    // Filtro de búsqueda
    $where = "";
    $bindTypes = "";
    $bindValues = [];

    if (!empty($search)) {
        $where = "
            WHERE 
                u.nombre_completo LIKE ? OR 
                u.rfc LIKE ? OR 
                u.curp LIKE ? OR 
                u.email LIKE ? OR 
                p.nombre_promotoria LIKE ? OR 
                pu.nombre_puesto LIKE ? OR 
                r.nombre_rol LIKE ?
        ";
        $searchWildcard = "%$search%";
        $bindTypes = str_repeat("s", 7);
        $bindValues = array_fill(0, 7, $searchWildcard);
    }

    // Conteo con filtro
    $stmtFiltered = $conexion->prepare("SELECT COUNT(*) AS filtered $baseQuery $where");
    if (!empty($search)) {
        $stmtFiltered->bind_param($bindTypes, ...$bindValues);
    }
    $stmtFiltered->execute();
    $filteredResult = $stmtFiltered->get_result()->fetch_assoc();
    $response['recordsFiltered'] = intval($filteredResult['filtered']);
    $stmtFiltered->close();

    // Datos con paginación
    $query = "
        SELECT 
            u.usuario_id, u.nombre_completo, u.rfc, u.curp, u.email, 
            u.estado_lugar, u.promotoria_id, p.nombre_promotoria, 
            u.puesto_id, pu.nombre_puesto, u.rol_id, r.nombre_rol, 
            u.status, u.fecha_ingreso, u.created_at, u.updated_at
        $baseQuery 
        $where 
        ORDER BY u.usuario_id DESC 
        LIMIT ?, ?
    ";

    if (!empty($search)) {
        $bindTypes .= "ii";
        $bindValues[] = $start;
        $bindValues[] = $length;
        $stmtData = $conexion->prepare($query);
        $stmtData->bind_param($bindTypes, ...$bindValues);
    } else {
        $stmtData = $conexion->prepare($query);
        $stmtData->bind_param("ii", $start, $length);
    }

    $stmtData->execute();
    $result = $stmtData->get_result();

    while ($row = $result->fetch_assoc()) {
        $row["acciones"] = '
            <div class="d-flex justify-content-center gap-2">
                <button class="btn btn-sm btn-primary editar-btn" data-id="' . $row['usuario_id'] . '">
                    <i class="bi bi-pencil-square"></i> Editar
                </button>
                <button class="btn btn-sm btn-danger eliminar-btn" data-id="' . $row['usuario_id'] . '">
                    <i class="bi bi-trash"></i> Eliminar
                </button>
            </div>
        ';
        $response['data'][] = $row;
    }

    $stmtData->close();
    $conexion->close();
} catch (Exception $e) {
    $response["error"] = $e->getMessage();
}

echo json_encode($response);
