<?php
header('Content-Type: application/json');
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);
session_start(); // Iniciar sesión si aún no está iniciada

// Verificar si el usuario está autenticado (ejemplo básico)
if (!isset($_SESSION['usuario_id'])) {
    http_response_code(401); // No autorizado
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$promotoria_id = filter_input(INPUT_GET, 'promotoria_id', FILTER_SANITIZE_NUMBER_INT);
if (!$promotoria_id) {
    http_response_code(400); // Solicitud incorrecta
    echo json_encode(['error' => 'ID de promotoria no válido.']);
    exit;
}
// Utilizar prepared statement para prevenir inyección SQL
$sql = "SELECT c.curso_id AS curso_id, c.curso_title AS nombre_curso
 FROM cursos_promotorias cp
 INNER JOIN cursos c ON cp.curso_id = c.curso_id
 WHERE cp.promotoria_id = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("i", $promotoria_id);
$stmt->execute();
$result = $stmt->get_result();

$cursos_asignados = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $cursos_asignados[] = $row;
    }
}

echo json_encode($cursos_asignados);

$stmt->close();
$conexion->close();
