<?php
require '../config/config.php'; // Conexión a MySQL optimizada

// Recibir el término de búsqueda desde la solicitud GET
$search = $_GET['q'] ?? '';
$searchTerm = '%' . $search . '%'; // Añadir comodines para el operador LIKE

// Consulta SQL
$sql = "SELECT tt.ID_Titulo, tt.curso_id, tt.nom_titulo_temario, c.curso_title AS TITULO_CURSO,  tt.orden FROM titulos_temarios tt LEFT JOIN cursos c ON c.curso_id = tt.curso_id 
            WHERE nom_titulo_temario LIKE ?  
            LIMIT 20;";

// Preparar y ejecutar la consulta
$stmt = $conexion->prepare($sql);
$stmt->bind_param("s", $searchTerm);
$stmt->execute();
$result = $stmt->get_result();

// Construir el resultado como JSON
$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Enviar el resultado al frontend
header('Content-Type: application/json');
echo json_encode($data);  // Solo esta línea es necesaria

// Cerrar la conexión
$stmt->close();
$conexion->close();
