<?php require '../config/config.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
    <title>Login</title>
</head>
<style>
    main {
        min-height: 100vh;
        background-repeat: no-repeat;
        background-position: center;
        background-size: cover;
        /*background-image: url(../images/background.jpg);*/
        background-color: aliceblue;
        -webkit-box-orient: vertical !important;
        -webkit-box-direction: normal !important;
        flex-direction: column !important;
    }

    .main-container {
        margin-bottom: auto !important;
        margin-top: auto !important;
        padding-bottom: 5rem !important;
        padding-top: 5rem !important;
    }

    .nm-aic {
        -webkit-box-align: center !important;
        align-items: center !important;
    }

    .nm-mb-1 {
        margin-bottom: 1.5rem !important;
    }

    .card {
        box-shadow: 0.125rem 1.25rem 2.25rem 0 rgba(153, 155, 168, 0.12);
        position: relative;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        flex-direction: column;
        min-width: 0;
        background-color: #ffffff;
        background-clip: border-box;
        border: 0 solid transparent;
        border-radius: 12px;
    }

    .card-content {
        padding: 1.5rem !important;
        -webkit-box-flex: 1;
        flex: 1 1 auto;
    }

    .nm-tc {
        text-align: center !important;
    }

    h2 {
        font-size: 1.5rem;
        font-weight: 600;
        margin-top: 0;
    }

    .form-group {
        margin-bottom: 1rem;
    }

    label {
        font-size: 1rem;
        color: #1e2022;
        margin-bottom: .5rem;
    }

    .form-control {
        display: block;
        width: 100%;
        height: auto;
        padding: 1.0625rem 1rem;
        font-size: 1rem;
        font-weight: 400;
        line-height: 1.2;
        color: #1e2022;
        background-color: #ffffff;
        background-clip: padding-box;
        border: 1px solid #eeeeff;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, -webkit-box-shadow 0.15s ease-in-out;
    }

    .nm-mt-1 {
        margin-top: 1.5rem !important;
    }

    .nm-jcb {
        -webkit-box-pack: justify !important;
        justify-content: space-between !important;
    }

    .nm-ft-b {
        font-weight: 600;
        font-size: 0.875rem;
    }

    a {
        transition: all .2s ease-in;
        text-decoration: none;
        background-color: transparent;
        color: #c41e3d;
    }

    .nm-btn {
        min-width: 9.25rem;
        font-weight: 600;
        font-size: 0.875rem;
        line-height: 1.2;
        text-align: center;
        vertical-align: middle;
        user-select: none;
        padding: 0.875rem 0.875rem;
        border-radius: 0.25rem;
        color: #ffffff;
        background-color: #007bff;
        border: 1px solid #007bff;
        transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, -webkit-box-shadow 0.15s ease-in-out;
    }

    .btn-block {
        width: 100%;
        margin-bottom: 1.5rem !important;
    }

    h2.large {
        font-size: 1.75rem;
        margin-bottom: 0.5rem;
        font-weight: 600;
    }

    .subtitle {
        margin-bottom: 2rem;
        font-weight: 600;
        line-height: 2;
        color: #007bff;
    }

    li {
        margin-bottom: 2rem !important;
    }

    .icon {
        width: 2.625rem;
        height: 2.625rem;
        font-size: 1.125rem;
        display: inline-flex;
        -webkit-box-align: center;
        align-items: center;
        -webkit-box-pack: center;
        justify-content: center;
        color: #007bff !important;
        margin-right: 1rem !important;
        border-radius: 50% !important;
        background-color: #fff !important;
    }



    @media (min-width: 1200px) {
        .card-content {
            padding: 3rem !important;
        }
    }

    @media (min-width: 992px) {
        .card-content {
            padding: 2rem !important;
        }
    }

    @media (min-width: 768px) {
        .nm-mb-md-1 {
            margin-bottom: 0rem !important;
        }

        .card-content {
            padding: 2rem !important;
        }
    }

    @media (min-width: 576px) {
        .card-content {
            padding: 2rem !important;
        }
    }
</style>


<body>
    <main class="d-flex">
        <div class="container main-container">
            <div class="row nm-aic">
                <div class="col-md-6 col-lg-5 offset-lg-1 nm-mb-1 nm-mb-md-1">
                    <div class="card">
                        <div class="card-content">
                            <h2 class="nm-tc nm-mb-1">Ingresar</h2>
                            <form id="loginForm">
                                <div class="form-group">
                                    <label for="inputEmail">Email</label>
                                    <input id="inputEmail" name="inputEmail" class="form-control" type="email"
                                        tabindex="1" placeholder="Ingrese su email" required>
                                </div>

                                <div class="form-group">
                                    <label for="inputPassword">Password</label>
                                    <input id="inputPassword" name="inputPassword" class="form-control" type="password"
                                        tabindex="2" placeholder="Ingrese su password" required>
                                </div>

                                <div class="d-flex nm-aic nm-jcb nm-mb-1 nm-mt-1">
                                    <a class="nm-ft-b" href="recover_2.html">¿Has olvidado tu contraseña?</a>
                                </div>

                                <button type="submit" class="btn btn-block btn-primary text-uppercase nm-btn">Iniciar
                                    Sesión</button>

                            </form>
                            <p class="text-center mb-0">
                                ¿No tienes un Cuenta?
                                <a class="nm-ft-b" href="./signup_2.html">Registrate</a>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-5 offset-lg-1" style=" padding-left: 12px; padding-right: 12px;">
                    <h2 class="large">Fortalece tu equipo y desarrolla el talento que impulsa tu organización.</h2>
                    <p class="subtitle"></p>
                    <ul class="list-unstyled mb-11">
                        <li>
                            <div class="list nm-aic">
                                <div class="icon">
                                    <i class="fas fa-briefcase"></i>
                                </div>

                                <div class="content">
                                    <p>Something about businesses that makes it special and different from everything
                                        else</p>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="list nm-aic">
                                <div class="icon">
                                    <i class="far fa-calendar-alt"></i>
                                </div>

                                <div class="content">
                                    <p>There is this saying about the business and entrepreneurship, but who remembers
                                        it anyway</p>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="list nm-aic">
                                <div class="icon">
                                    <i class="fas fa-trophy"></i>
                                </div>

                                <div class="content">
                                    <p>If only there was a template for all your needs wait a second there is and it is
                                        called this</p>
                                </div>
                            </div>
                        </li>
                    </ul>


                    <a href="../../index.php" class="btn btn-primary text-uppercase nm-btn">Volver al Inicio</a>
                </div>
            </div>
        </div>
    </main>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Carga de SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
        $(document).ready(function() {
            $("#loginForm").submit(function(event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    url: "<?php echo $URL ?>/src/controllers/loginControllers.php",
                    data: $(this).serialize(),
                    dataType: "json",
                    beforeSend: function() {
                        Swal.fire({
                            title: "Verificando...",
                            text: "Por favor, espera.",
                            allowOutsideClick: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });
                    },
                    success: function(response) {
                        Swal.close();
                        if (response.status === "success") {
                            $("#loginForm")[0].reset();
                            Swal.fire({
                                icon: "success",
                                title: "¡Bienvenido!",
                                text: response.message,
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.href = response.redirect;
                            });
                        } else {
                            Swal.fire({
                                icon: "error",
                                title: "Error",
                                text: response.message,
                                confirmButtonText: "Intentar de nuevo"
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log("Estado: " + status);
                        console.log("Error: " + error);
                        console.log("Respuesta del servidor: " + xhr.responseText);

                        Swal.fire({
                            icon: "error",
                            title: "Error en el servidor",
                            text: "Detalles: " + xhr.responseText,
                            confirmButtonText: "OK"
                        });
                    }

                });
            });
        });
    </script>
</body>

</html>